/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class SyncFutureWaiter
implements Executor {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();

    @Override
    public void execute(Runnable command) {
        this.lock.lock();
        try {
            this.tasks.add(command);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public <R> R listenForResult(CompletionStage<R> stage) throws Throwable {
        Waiter<R> waiter = new Waiter<R>();
        waiter.listenForResult(stage);
        return waiter.waitAndWork();
    }

    private class Waiter<R> {
        private boolean complete = false;
        private Throwable failure;
        private R result;

        private Waiter() {
        }

        public void listenForResult(CompletionStage<R> stage) {
            stage.whenComplete((r, t) -> {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                SyncFutureWaiter.this.lock.lock();
                try {
                    this.complete = true;
                    this.failure = t;
                    this.result = r;
                    SyncFutureWaiter.this.condition.signalAll();
                }
                finally {
                    SyncFutureWaiter.this.lock.unlock();
                }
            });
        }

        public R waitAndWork() throws InterruptedException, Throwable {
            SyncFutureWaiter.this.lock.lock();
            try {
                while (!this.complete) {
                    Runnable task = (Runnable)SyncFutureWaiter.this.tasks.poll();
                    if (task == null) {
                        SyncFutureWaiter.this.condition.await();
                        continue;
                    }
                    task.run();
                }
                if (this.result == null) {
                    throw this.failure;
                }
                R r = this.result;
                return r;
            }
            finally {
                SyncFutureWaiter.this.lock.unlock();
            }
        }
    }
}

