/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class TopicRefWriter
extends AbstractXMLFilter {
    private Map<URI, URI> changeTable = null;
    private Map<URI, URI> conflictTable = null;
    private String fixpath = null;

    @Override
    public void write(File outputFilename) throws DITAOTException {
        this.setCurrentFile(outputFilename.toURI());
        this.logger.info("Process " + String.valueOf(outputFilename.toURI()));
        super.write(outputFilename);
    }

    public void setup(Map<URI, URI> conflictTable) {
        for (Map.Entry<URI, URI> e : conflictTable.entrySet()) {
            assert (e.getKey().isAbsolute());
            assert (e.getValue().isAbsolute());
        }
        this.conflictTable = conflictTable;
    }

    public void setChangeTable(Map<URI, URI> changeTable) {
        assert (changeTable != null && !changeTable.isEmpty());
        for (Map.Entry<URI, URI> e : changeTable.entrySet()) {
            assert (e.getKey().isAbsolute());
            assert (e.getValue().isAbsolute());
        }
        this.changeTable = changeTable;
    }

    public void setFixpath(String fixpath) {
        assert (fixpath == null || !URLUtils.toFile(fixpath).isAbsolute());
        this.fixpath = fixpath;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        String tmp;
        if (this.fixpath != null && target.equals("workdir")) {
            String tmp2 = this.fixpath.substring(0, this.fixpath.lastIndexOf("/"));
            if (!((String)data).endsWith(tmp2)) {
                data = (String)data + File.separator + tmp2;
            }
        } else if (this.fixpath != null && target.equals("workdir-uri") && !((String)data).endsWith(tmp = this.fixpath.substring(0, this.fixpath.lastIndexOf("/") + 1))) {
            data = (String)data + tmp;
        }
        this.getContentHandler().processingInstruction(target, (String)data);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Attributes as = atts;
        if (Constants.TOPIC_OBJECT.matches(atts)) {
            String data = atts.getValue("data");
            if (data != null) {
                AttributesImpl res = new AttributesImpl(atts);
                XMLUtils.addOrSetAttribute(res, "data", this.updateData(data));
                as = res;
            }
        } else {
            String href = atts.getValue("href");
            if (href != null) {
                AttributesImpl res = new AttributesImpl(atts);
                XMLUtils.addOrSetAttribute(res, "href", this.updateHref(as));
                as = res;
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, as);
    }

    private boolean isLocalDita(Attributes atts) {
        String classValue = atts.getValue("class");
        if (classValue == null || Constants.TOPIC_IMAGE.matches(classValue)) {
            return false;
        }
        String scopeValue = atts.getValue("scope");
        String formatValue = atts.getValue("format");
        if (formatValue == null) {
            formatValue = "dita";
        }
        return DitaUtils.isLocalScope(scopeValue) && formatValue.equals("dita");
    }

    private String updateData(String origValue) {
        String hrefValue = origValue;
        if (this.fixpath != null && hrefValue.startsWith(this.fixpath)) {
            hrefValue = hrefValue.substring(this.fixpath.length());
        }
        return hrefValue;
    }

    private String updateHref(Attributes atts) {
        String hrefValue = atts.getValue("href");
        if (hrefValue == null) {
            return null;
        }
        if (this.fixpath != null && hrefValue.startsWith(this.fixpath)) {
            hrefValue = hrefValue.substring(this.fixpath.length());
        }
        if (this.changeTable == null || this.changeTable.isEmpty()) {
            return hrefValue;
        }
        if (this.isLocalDita(atts)) {
            URI changeTarget_with_elemt;
            URI rootPathName = this.currentFile;
            URI target = this.currentFile.resolve(hrefValue);
            URI changeTargetkey = URLUtils.stripFragment(target);
            URI changeTarget = this.changeTable.get(changeTargetkey);
            String topicID = URLUtils.getTopicID(URLUtils.toURI(hrefValue));
            if (topicID != null && (changeTarget_with_elemt = this.changeTable.get(changeTargetkey = URLUtils.setFragment(changeTargetkey, topicID))) != null) {
                changeTarget = changeTarget_with_elemt;
            }
            String elementID = this.getElementID(hrefValue);
            String pathtoElem = FileUtils.getFragment(hrefValue, "");
            if (changeTarget == null || changeTarget.toString().isEmpty()) {
                URI absolutePath = this.currentFile.resolve(hrefValue);
                absolutePath = URLUtils.setElementID(absolutePath, null);
                changeTarget = this.changeTable.get(absolutePath);
            }
            if (changeTarget == null) {
                return hrefValue;
            }
            URI conTarget = this.conflictTable.get(URLUtils.stripFragment(changeTarget));
            this.logger.debug("Update " + String.valueOf(changeTarget) + " to " + String.valueOf(conTarget));
            if (conTarget != null && !conTarget.toString().isEmpty()) {
                URI p = URLUtils.getRelativePath(rootPathName, conTarget);
                if (elementID == null) {
                    return URLUtils.setFragment(p, this.getElementID(changeTarget.toString())).toString();
                }
                if (conTarget.getFragment() != null) {
                    if (!pathtoElem.contains("/")) {
                        return p.toString();
                    }
                    return URLUtils.setElementID(p, elementID).toString();
                }
                return URLUtils.setFragment(p, pathtoElem).toString();
            }
            URI p = URLUtils.getRelativePath(rootPathName, changeTarget);
            if (elementID == null) {
                return p.toString();
            }
            if (changeTarget.getFragment() != null) {
                if (!pathtoElem.contains("/")) {
                    return p.toString();
                }
                return URLUtils.setElementID(p, elementID).toString();
            }
            return URLUtils.setFragment(p, pathtoElem).toString();
        }
        return hrefValue;
    }

    private String getElementID(String relativePath) {
        String fragment = FileUtils.getFragment(relativePath);
        if (fragment != null) {
            if (fragment.lastIndexOf("/") != -1) {
                return fragment.substring(fragment.lastIndexOf("/") + 1);
            }
            return fragment;
        }
        return null;
    }
}

