/* snpMap.c was originally generated by the autoSql program, which also 
 * generated snpMap.h and snpMap.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "snpMap.h"


void snpMapStaticLoad(char **row, struct snpMap *ret)
/* Load a row from snpMap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->source = row[4];
ret->type = row[5];
}

struct snpMap *snpMapLoad(char **row)
/* Load a snpMap from row fetched with select * from snpMap
 * from database.  Dispose of this with snpMapFree(). */
{
struct snpMap *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->source = cloneString(row[4]);
ret->type = cloneString(row[5]);
return ret;
}

struct snpMap *snpMapLoadAll(char *fileName) 
/* Load all snpMap from a whitespace-separated file.
 * Dispose of this with snpMapFreeList(). */
{
struct snpMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = snpMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpMap *snpMapLoadAllByChar(char *fileName, char chopper) 
/* Load all snpMap from a chopper separated file.
 * Dispose of this with snpMapFreeList(). */
{
struct snpMap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = snpMapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpMap *snpMapLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all snpMap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with snpMapFreeList(). */
{
struct snpMap *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = snpMapLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void snpMapSaveToDb(struct sqlConnection *conn, struct snpMap *el, char *tableName, int updateSize)
/* Save snpMap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use snpMapSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s','%s','%s')", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->source,  el->type);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void snpMapSaveToDbEscaped(struct sqlConnection *conn, struct snpMap *el, char *tableName, int updateSize)
/* Save snpMap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than snpMapSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *chrom, *name, *source, *type;
chrom = sqlEscapeString(el->chrom);
name = sqlEscapeString(el->name);
source = sqlEscapeString(el->source);
type = sqlEscapeString(el->type);

dyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s','%s','%s')", 
	tableName,  chrom, el->chromStart , el->chromEnd ,  name,  source,  type);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&chrom);
freez(&name);
freez(&source);
freez(&type);
}

struct snpMap *snpMapCommaIn(char **pS, struct snpMap *ret)
/* Create a snpMap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new snpMap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->source = sqlStringComma(&s);
ret->type = sqlStringComma(&s);
*pS = s;
return ret;
}

void snpMapFree(struct snpMap **pEl)
/* Free a single dynamically allocated snpMap such as created
 * with snpMapLoad(). */
{
struct snpMap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->source);
freeMem(el->type);
freez(pEl);
}

void snpMapFreeList(struct snpMap **pList)
/* Free a list of dynamically allocated snpMap's */
{
struct snpMap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    snpMapFree(&el);
    }
*pList = NULL;
}

void snpMapOutput(struct snpMap *el, FILE *f, char sep, char lastSep) 
/* Print out snpMap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->source);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

