/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.token;

import com.google.common.collect.Lists;
import com.google.jstestdriver.token.Token;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedTokenStream {
    private final Iterator<Token> iterator;
    private int streamPos = 0;
    private int bufferIndex = 0;
    private final int readAhead = 2;
    private List<Token> buffer = Lists.newArrayList();

    public BufferedTokenStream(Iterator<Token> iterator) {
        this.iterator = iterator;
    }

    public Token read() {
        while (this.iterator.hasNext() && this.buffer.size() - (this.bufferIndex + 1) < 2) {
            ++this.streamPos;
            this.buffer.add(this.iterator.next());
        }
        if (this.isBufferEmpty()) {
            return null;
        }
        Token token = this.buffer.get(this.bufferIndex++);
        return token;
    }

    private boolean isBufferEmpty() {
        return this.buffer.isEmpty() || this.bufferIndex + 1 > this.buffer.size();
    }

    public boolean available() {
        return this.iterator.hasNext() || !this.isBufferEmpty();
    }

    public void mark() {
        List<Token> oldBuffer = this.buffer;
        this.buffer = Lists.newArrayList();
        this.buffer.addAll(oldBuffer.subList(this.bufferIndex, oldBuffer.size()));
        this.bufferIndex = 0;
    }

    public void reset() {
        this.bufferIndex = 0;
    }
}

