/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeQueue<T>
extends IStructure<T> {
    AtomicReference<IStructure.Node<T>> head = null;
    AtomicReference<IStructure.Node<T>> tail = null;

    public LockFreeQueue() {
        IStructure.Node<Object> dummy = new IStructure.Node<Object>(null);
        this.head = new AtomicReference<IStructure.Node<Object>>(dummy);
        this.tail = new AtomicReference<IStructure.Node<Object>>(dummy);
    }

    @Override
    public void add(T item) {
        IStructure.Node<T> node = new IStructure.Node<T>(item);
        while (true) {
            IStructure.Node<T> last2 = this.tail.get();
            IStructure.Node next2 = last2.next.get();
            if (last2 != this.tail.get()) continue;
            if (next2 == null) {
                if (!last2.next.compareAndSet(next2, node)) continue;
                this.tail.compareAndSet(last2, node);
                return;
            }
            this.tail.compareAndSet(last2, next2);
        }
    }

    @Override
    public boolean isEmpty() {
        IStructure.Node<T> first = this.head.get();
        IStructure.Node<T> last2 = this.tail.get();
        IStructure.Node next2 = first.next.get();
        return first == this.head.get() && first == last2 && next2 == null;
    }

    @Override
    public T remove() {
        Object value;
        while (true) {
            IStructure.Node<T> first = this.head.get();
            IStructure.Node<T> last2 = this.tail.get();
            IStructure.Node next2 = first.next.get();
            if (first != this.head.get()) continue;
            if (first == last2) {
                if (next2 == null) {
                    return null;
                }
                this.tail.compareAndSet(last2, next2);
                continue;
            }
            value = next2.value;
            if (this.head.compareAndSet(first, next2)) break;
        }
        return value;
    }
}

