/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.openide.util.WeakListeners;

class WeakAction
implements Action,
PropertyChangeListener {
    private Reference<Action> original;
    private Icon icon;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private String name = null;
    private boolean wasEnabled = true;
    private boolean hadOriginal = true;

    public WeakAction(Action action) {
        this.wasEnabled = action.isEnabled();
        this.icon = (Icon)action.getValue("SmallIcon");
        this.name = (String)action.getValue("Name");
        this.original = new WeakReference<Action>(action);
        action.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Action action = this.getOriginal();
        if (action != null) {
            action.actionPerformed(actionEvent);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public Object getValue(String string) {
        if ("SmallIcon".equals(string)) {
            return this.icon;
        }
        Action action = this.getOriginal();
        if (action != null) {
            return action.getValue(string);
        }
        if ("Name".equals(string)) {
            return this.name;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        Action action = this.getOriginal();
        if (action != null) {
            this.wasEnabled = action.isEnabled();
            return this.wasEnabled;
        }
        return false;
    }

    @Override
    public void putValue(String string, Object object) {
        if ("SmallIcon".equals(string)) {
            this.icon = (Icon)object;
        } else {
            Action action = this.getOriginal();
            if (action != null) {
                action.putValue(string, object);
            }
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        Action action = this.getOriginal();
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    private Action getOriginal() {
        Action action = this.original.get();
        if (action == null && this.hadOriginal && this.wasEnabled) {
            this.hadOriginal = false;
            this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
        }
        return action;
    }

    private synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.wasEnabled = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
        }
    }
}

