/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileFilterSupport {
    private static final Logger LOG = Logger.getLogger(FileFilterSupport.class.getName());

    private FileFilterSupport() {
    }

    private static String constructFilterDisplayName(String string, List<FilterElement> list) {
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = true;
        stringBuilder.append(" [");
        for (FilterElement filterElement : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(filterElement.getName());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static boolean accept(File file, List<FilterElement> list) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            for (FilterElement filterElement : list) {
                if (!filterElement.accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<FileFilter> findRegisteredFileFilters() {
        LinkedList<FileFilter> linkedList = new LinkedList<FileFilter>();
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/MIMEResolver");
        HashMap<String, HashSet<FileObject>> hashMap = new HashMap<String, HashSet<FileObject>>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string;
            if (fileObject2.isFolder()) continue;
            int n = 0;
            while ((string = (String)fileObject2.getAttribute("fileChooser." + n)) != null) {
                HashSet<FileObject> hashSet = (HashSet<FileObject>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<FileObject>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(fileObject2);
                ++n;
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            linkedList.add(FileFilterSupport.createFilter((String)entry.getKey(), (Set)entry.getValue()));
        }
        return FileFilterSupport.sortFiltersByDescription(linkedList);
    }

    private static FileFilter createFilter(String string, Set<FileObject> set) {
        ArrayList<FilterElement> arrayList = new ArrayList<FilterElement>(3);
        for (FileObject fileObject : set) {
            String string2;
            int n = 0;
            while ((string2 = (String)fileObject.getAttribute("ext." + n)) != null) {
                FileFilterSupport.addExtensionToList(arrayList, string2);
                ++n;
            }
            int n2 = 0;
            while ((string2 = (String)fileObject.getAttribute("fileName." + n2++)) != null) {
                FileFilterSupport.addNameToList(arrayList, string2);
            }
            String string3 = (String)fileObject.getAttribute("mimeType");
            if (string3 != null) {
                FileFilterSupport.addMimeTypeExts(arrayList, string3);
            }
            int n3 = 0;
            while ((string3 = (String)fileObject.getAttribute("mimeType." + n3++)) != null) {
                FileFilterSupport.addMimeTypeExts(arrayList, string3);
            }
        }
        FileFilterSupport.sortFilterElements(arrayList);
        return new FileFilterImpl(string, arrayList);
    }

    private static void addMimeTypeExts(List<FilterElement> list, String string) {
        FileFilterSupport.addAllExtensionsToList(list, FileUtil.getMIMETypeExtensions((String)string));
    }

    private static void addAllExtensionsToList(List<FilterElement> list, List<String> list2) {
        for (String string : list2) {
            FileFilterSupport.addExtensionToList(list, string);
        }
    }

    private static void addExtensionToList(List<FilterElement> list, String string) {
        FileFilterSupport.addFilterElementToList(list, FilterElement.createForExtension(string));
    }

    private static void addNameToList(List<FilterElement> list, String string) {
        Pattern pattern = Pattern.compile("\\[([^,]+), (true|false), (true|false)\\](\\S*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            boolean bl = matcher.group(2).equals("true");
            boolean bl2 = matcher.group(3).equals("true");
            String string3 = matcher.group(4);
            FileFilterSupport.addFilterElementToList(list, FilterElement.createForFileName(string2, string3, bl, bl2));
        } else {
            LOG.log(Level.INFO, "Incorrect name pattern {0}", string);
        }
    }

    private static void addFilterElementToList(List<FilterElement> list, FilterElement filterElement) {
        block5: for (int i = 0; i < list.size(); ++i) {
            FilterElement filterElement2 = list.get(i);
            FilterElement.ComparisonResult comparisonResult = filterElement.compare(filterElement2);
            switch (comparisonResult) {
                case DIFFERENT: {
                    continue block5;
                }
                case THE_SAME: 
                case WORSE: {
                    return;
                }
                case BETTER: {
                    list.set(i, filterElement);
                    return;
                }
            }
        }
        list.add(filterElement);
    }

    private static List<FileFilter> sortFiltersByDescription(List<FileFilter> list) {
        list.sort(new Comparator<FileFilter>(){

            @Override
            public int compare(FileFilter fileFilter, FileFilter fileFilter2) {
                return fileFilter.getDescription().compareTo(fileFilter2.getDescription());
            }
        });
        return list;
    }

    private static List<FilterElement> sortFilterElements(List<FilterElement> list) {
        list.sort(new Comparator<FilterElement>(){

            @Override
            public int compare(FilterElement filterElement, FilterElement filterElement2) {
                return filterElement.getName().compareTo(filterElement2.getName());
            }
        });
        return list;
    }

    private static abstract class FilterElement {
        private FilterElement() {
        }

        public abstract String getName();

        public abstract boolean accept(File var1);

        public abstract ComparisonResult compare(FilterElement var1);

        public static FilterElement createForExtension(String string) {
            return new ExtensionBasedFilterElement(string);
        }

        public static FilterElement createForFileName(String string, String string2, boolean bl, boolean bl2) {
            return new NameBasedFilterElement(string, string2, bl, bl2);
        }

        private static class NameBasedFilterElement
        extends FilterElement {
            String name;
            String ext;
            boolean substring;
            boolean ignoreCase;
            Pattern p;

            public NameBasedFilterElement(String string, String string2, boolean bl, boolean bl2) {
                this.name = string;
                this.ext = string2;
                this.substring = bl;
                this.ignoreCase = bl2;
                StringBuilder stringBuilder = new StringBuilder();
                if (bl2) {
                    stringBuilder.append("(?i)");
                }
                if (bl) {
                    stringBuilder.append(".*");
                }
                stringBuilder.append(string);
                if (bl) {
                    stringBuilder.append(".*");
                }
                if (!string2.isEmpty()) {
                    stringBuilder.append("\\.");
                    stringBuilder.append(string2);
                }
                this.p = Pattern.compile(stringBuilder.toString());
            }

            @Override
            public String getName() {
                return this.name + (this.ext.isEmpty() ? "" : "." + this.ext);
            }

            @Override
            public boolean accept(File file) {
                return this.p.matcher(file.getName()).matches();
            }

            @Override
            public ComparisonResult compare(FilterElement filterElement) {
                if (filterElement == null) {
                    throw new NullPointerException();
                }
                if (!(filterElement instanceof NameBasedFilterElement)) {
                    return ComparisonResult.DIFFERENT;
                }
                NameBasedFilterElement nameBasedFilterElement = (NameBasedFilterElement)filterElement;
                if (this.name.equals(nameBasedFilterElement.name) && this.ext.equals(nameBasedFilterElement.ext)) {
                    if (this.substring == nameBasedFilterElement.substring && this.ignoreCase == nameBasedFilterElement.ignoreCase) {
                        return ComparisonResult.THE_SAME;
                    }
                    return this.compareFlags(nameBasedFilterElement);
                }
                if (this.ext.equalsIgnoreCase(nameBasedFilterElement.ext) && this.name.equalsIgnoreCase(nameBasedFilterElement.name) && (this.ignoreCase || nameBasedFilterElement.ignoreCase)) {
                    if (this.substring == nameBasedFilterElement.substring && this.ignoreCase == nameBasedFilterElement.ignoreCase) {
                        if (Character.isLowerCase(this.name.charAt(0))) {
                            return ComparisonResult.BETTER;
                        }
                        return ComparisonResult.WORSE;
                    }
                    return this.compareFlags(nameBasedFilterElement);
                }
                return ComparisonResult.DIFFERENT;
            }

            private ComparisonResult compareFlags(NameBasedFilterElement nameBasedFilterElement) {
                if (this.substring == nameBasedFilterElement.substring && this.ignoreCase) {
                    return ComparisonResult.BETTER;
                }
                if (this.ignoreCase == nameBasedFilterElement.ignoreCase && this.substring) {
                    return ComparisonResult.BETTER;
                }
                if (this.substring != nameBasedFilterElement.substring && this.ignoreCase != nameBasedFilterElement.ignoreCase) {
                    return ComparisonResult.DIFFERENT;
                }
                return ComparisonResult.WORSE;
            }
        }

        private static class ExtensionBasedFilterElement
        extends FilterElement {
            private final String extension;

            public ExtensionBasedFilterElement(String string) {
                if (string == null) {
                    throw new NullPointerException();
                }
                this.extension = string;
            }

            @Override
            public String getName() {
                return "." + this.extension;
            }

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith("." + this.extension.toLowerCase());
            }

            @Override
            public ComparisonResult compare(FilterElement filterElement) {
                if (!(filterElement instanceof ExtensionBasedFilterElement)) {
                    return ComparisonResult.DIFFERENT;
                }
                ExtensionBasedFilterElement extensionBasedFilterElement = (ExtensionBasedFilterElement)filterElement;
                if (extensionBasedFilterElement == null) {
                    throw new NullPointerException();
                }
                if (this.extension.equals(extensionBasedFilterElement.extension)) {
                    return ComparisonResult.THE_SAME;
                }
                if (this.extension.equalsIgnoreCase(extensionBasedFilterElement.extension) && this.extension.length() > 1) {
                    if (Character.isUpperCase(extensionBasedFilterElement.extension.charAt(0))) {
                        return ComparisonResult.BETTER;
                    }
                    return ComparisonResult.WORSE;
                }
                return ComparisonResult.DIFFERENT;
            }
        }

        public static enum ComparisonResult {
            THE_SAME,
            BETTER,
            WORSE,
            DIFFERENT;

        }
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String name;
        List<FilterElement> filterElements;

        public FileFilterImpl(String string, List<FilterElement> list) {
            this.name = string;
            this.filterElements = list;
        }

        @Override
        public boolean accept(File file) {
            return FileFilterSupport.accept(file, this.filterElements);
        }

        @Override
        public String getDescription() {
            return FileFilterSupport.constructFilterDisplayName(this.name, this.filterElements);
        }
    }
}

