/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.List;
import org.testng.ISuite;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class ReporterPanel
extends BaseMultiSuitePanel {
    public ReporterPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "reporter-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return "Reporter output for " + iSuite.getName();
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        for (ITestResult iTestResult : this.getModel().getAllTestResults(iSuite)) {
            List<String> list = Reporter.getOutput(iTestResult);
            if (list.isEmpty()) continue;
            xMLStringBuffer2.push("div", "class", "reporter-method-div");
            xMLStringBuffer2.addRequired("span", Model.getTestResultName(iTestResult), "class", "reporter-method-name");
            xMLStringBuffer2.push("div", "class", "reporter-method-output-div");
            for (String string : list) {
                xMLStringBuffer2.addRequired("span", string, "class", "reporter-method-output");
            }
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
        }
        return xMLStringBuffer2.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return "Reporter output";
    }
}

