/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.strings;

import com.github.tomtung.latex2unicode.LaTeX2Unicode;
import java.text.Normalizer;
import java.util.Objects;
import java.util.regex.Pattern;

public class LatexToUnicodeAdapter {
    private static Pattern underscoreMatcher = Pattern.compile("_(?!\\{)");
    private static String replacementChar = "\ufffd";
    private static Pattern underscorePlaceholderMatcher = Pattern.compile(replacementChar);

    public static String format(String inField) {
        Objects.requireNonNull(inField);
        String toFormat = underscoreMatcher.matcher(inField).replaceAll(replacementChar);
        toFormat = Normalizer.normalize(LaTeX2Unicode.convert(toFormat), Normalizer.Form.NFC);
        return underscorePlaceholderMatcher.matcher(toFormat).replaceAll("_");
    }
}

