/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import org.jabref.logic.layout.LayoutFormatter;

public class RemoveLatexCommandsFormatter
implements LayoutFormatter {
    @Override
    public String format(String field2) {
        StringBuilder sb = new StringBuilder("");
        StringBuilder currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field2.length(); ++i) {
            char c = field2.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                incommand = true;
                currentCommand = new StringBuilder();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || "\"`^~'=.|".contains(String.valueOf(c))) {
                escaped = false;
                if (incommand) {
                    currentCommand.append(c);
                    if (currentCommand.length() != 1 || !"\"`^~'=.|".contains(currentCommand.toString())) continue;
                    incommand = false;
                    escaped = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (Character.isLetter(c)) {
                escaped = false;
                if (incommand) {
                    currentCommand.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (!incommand || !Character.isWhitespace(c) && c != '{') {
                sb.append(c);
            } else if (c != '{') {
                sb.append(c);
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString();
    }
}

