/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jabref.logic.layout.AbstractParamLayoutFormatter;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;

public class Authors
extends AbstractParamLayoutFormatter {
    private static final List<String> AUTHOR_ORDER = new ArrayList<String>();
    private static final List<String> AUTHOR_ABRV = new ArrayList<String>();
    private static final List<String> AUTHOR_PUNC = new ArrayList<String>();
    private static final List<String> SEPARATORS = new ArrayList<String>();
    private static final List<String> LAST_SEPARATORS = new ArrayList<String>();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
    private static final int FIRST_FIRST = 0;
    private static final int LAST_FIRST = 1;
    private static final int LF_FF = 2;
    private static final String COMMA = ", ";
    private static final String AMP = " & ";
    private static final String COLON = ": ";
    private static final String SEMICOLON = "; ";
    private static final String AND = " and ";
    private static final String OXFORD = ", and ";
    private int flMode;
    private boolean abbreviate = true;
    private boolean firstInitialOnly;
    private boolean middleInitial;
    private boolean lastNameOnly;
    private boolean abbrDots = true;
    private boolean abbrSpaces = true;
    private boolean setSep;
    private boolean setMaxAuthors;
    private int maxAuthors = -1;
    private int authorNumberEtAl = 1;
    private String lastFirstSeparator = ", ";
    private String separator = ", ";
    private String lastSeparator = " and ";
    private String etAlString = " et al.";

    @Override
    public void setArgument(String arg) {
        List<String> parts = AbstractParamLayoutFormatter.parseArgument(arg);
        for (String part : parts) {
            int index = part.indexOf(61);
            if (index > 0) {
                String key = part.substring(0, index);
                String value = part.substring(index + 1);
                this.handleArgument(key, value);
                continue;
            }
            this.handleArgument(part, "");
        }
    }

    private void handleArgument(String key, String value) {
        if (AUTHOR_ORDER.contains(key.trim().toLowerCase(Locale.ROOT))) {
            if (Authors.comp(key, "FirstFirst")) {
                this.flMode = 0;
            } else if (Authors.comp(key, "LastFirst")) {
                this.flMode = 1;
            } else if (Authors.comp(key, "LastFirstFirstFirst")) {
                this.flMode = 2;
            }
        } else if (AUTHOR_ABRV.contains(key.trim().toLowerCase(Locale.ROOT))) {
            if (Authors.comp(key, "FullName")) {
                this.abbreviate = false;
            } else if (Authors.comp(key, "Initials")) {
                this.abbreviate = true;
                this.firstInitialOnly = false;
            } else if (Authors.comp(key, "FirstInitial")) {
                this.abbreviate = true;
                this.firstInitialOnly = true;
            } else if (Authors.comp(key, "MiddleInitial")) {
                this.abbreviate = true;
                this.middleInitial = true;
            } else if (Authors.comp(key, "LastName")) {
                this.lastNameOnly = true;
            } else if (Authors.comp(key, "InitialsNoSpace")) {
                this.abbreviate = true;
                this.abbrSpaces = false;
            }
        } else if (AUTHOR_PUNC.contains(key.trim().toLowerCase(Locale.ROOT))) {
            if (Authors.comp(key, "FullPunc")) {
                this.abbrDots = true;
                this.lastFirstSeparator = COMMA;
            } else if (Authors.comp(key, "NoPunc")) {
                this.abbrDots = false;
                this.lastFirstSeparator = " ";
            } else if (Authors.comp(key, "NoComma")) {
                this.abbrDots = true;
                this.lastFirstSeparator = " ";
            } else if (Authors.comp(key, "NoPeriod")) {
                this.abbrDots = false;
                this.lastFirstSeparator = COMMA;
            }
        } else if (SEPARATORS.contains(key.trim().toLowerCase(Locale.ROOT)) || LAST_SEPARATORS.contains(key.trim().toLowerCase(Locale.ROOT))) {
            if (Authors.comp(key, "Comma")) {
                if (this.setSep) {
                    this.lastSeparator = COMMA;
                } else {
                    this.separator = COMMA;
                    this.setSep = true;
                }
            } else if (Authors.comp(key, "And")) {
                if (this.setSep) {
                    this.lastSeparator = AND;
                } else {
                    this.separator = AND;
                    this.setSep = true;
                }
            } else if (Authors.comp(key, "Colon")) {
                if (this.setSep) {
                    this.lastSeparator = COLON;
                } else {
                    this.separator = COLON;
                    this.setSep = true;
                }
            } else if (Authors.comp(key, "Semicolon")) {
                if (this.setSep) {
                    this.lastSeparator = SEMICOLON;
                } else {
                    this.separator = SEMICOLON;
                    this.setSep = true;
                }
            } else if (Authors.comp(key, "Oxford")) {
                this.lastSeparator = OXFORD;
            } else if (Authors.comp(key, "Amp")) {
                this.lastSeparator = AMP;
            } else if (Authors.comp(key, "Sep") && !value.isEmpty()) {
                this.separator = value;
                this.setSep = true;
            } else if (Authors.comp(key, "LastSep") && !value.isEmpty()) {
                this.lastSeparator = value;
            }
        } else if ("etal".equalsIgnoreCase(key.trim())) {
            this.etAlString = value;
        } else if (NUMBER_PATTERN.matcher(key.trim()).matches()) {
            int num = Integer.parseInt(key.trim());
            if (this.setMaxAuthors) {
                this.authorNumberEtAl = num;
            } else {
                this.maxAuthors = num;
                this.setMaxAuthors = true;
            }
        }
    }

    private static boolean comp(String one, String two) {
        return one.trim().equalsIgnoreCase(two);
    }

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        AuthorList al = AuthorList.parse(fieldText);
        if (this.maxAuthors < 0 || al.getNumberOfAuthors() <= this.maxAuthors) {
            for (int i = 0; i < al.getNumberOfAuthors(); ++i) {
                Author a = al.getAuthor(i);
                this.addSingleName(sb, a, this.flMode == 0 || this.flMode == 2 && i > 0);
                if (i < al.getNumberOfAuthors() - 2) {
                    sb.append(this.separator);
                    continue;
                }
                if (i >= al.getNumberOfAuthors() - 1) continue;
                sb.append(this.lastSeparator);
            }
        } else {
            for (int i = 0; i < Math.min(al.getNumberOfAuthors() - 1, this.authorNumberEtAl); ++i) {
                if (i > 0) {
                    sb.append(this.separator);
                }
                this.addSingleName(sb, al.getAuthor(i), this.flMode == 0);
            }
            sb.append(this.etAlString);
        }
        return sb.toString();
    }

    private void addSingleName(StringBuilder sb, Author a, boolean firstFirst) {
        StringBuilder lastNameSB = new StringBuilder();
        a.getVon().filter(von -> !von.isEmpty()).ifPresent(von -> lastNameSB.append((String)von).append(' '));
        a.getLast().ifPresent(lastNameSB::append);
        String jrSeparator = " ";
        a.getJr().filter(jr -> !jr.isEmpty()).ifPresent(jr -> lastNameSB.append(jrSeparator).append((String)jr));
        String firstNameResult = "";
        if (a.getFirst().isPresent()) {
            if (this.abbreviate) {
                firstNameResult = a.getFirstAbbr().orElse("");
                if (this.firstInitialOnly && firstNameResult.length() > 2) {
                    firstNameResult = firstNameResult.substring(0, 2);
                } else if (this.middleInitial) {
                    String abbr = firstNameResult;
                    firstNameResult = a.getFirst().get();
                    int index = firstNameResult.indexOf(32);
                    if (index >= 0) {
                        firstNameResult = firstNameResult.substring(0, index + 1);
                        if (abbr.length() > 3) {
                            firstNameResult = firstNameResult + abbr.substring(3);
                        }
                    }
                }
                if (!this.abbrDots) {
                    firstNameResult = firstNameResult.replace(".", "");
                }
                if (!this.abbrSpaces) {
                    firstNameResult = firstNameResult.replace(" ", "");
                }
            } else {
                firstNameResult = a.getFirst().get();
            }
        }
        if (this.lastNameOnly || firstNameResult.isEmpty()) {
            sb.append((CharSequence)lastNameSB);
        } else if (firstFirst) {
            String firstFirstSeparator = " ";
            sb.append(firstNameResult).append(firstFirstSeparator);
            sb.append((CharSequence)lastNameSB);
        } else {
            sb.append((CharSequence)lastNameSB).append(this.lastFirstSeparator).append(firstNameResult);
        }
    }

    static {
        AUTHOR_ORDER.add("firstfirst");
        AUTHOR_ORDER.add("lastfirst");
        AUTHOR_ORDER.add("lastfirstfirstfirst");
        AUTHOR_ABRV.add("fullname");
        AUTHOR_ABRV.add("initials");
        AUTHOR_ABRV.add("firstinitial");
        AUTHOR_ABRV.add("middleinitial");
        AUTHOR_ABRV.add("lastname");
        AUTHOR_ABRV.add("initialsnospace");
        AUTHOR_PUNC.add("fullpunc");
        AUTHOR_PUNC.add("nopunc");
        AUTHOR_PUNC.add("nocomma");
        AUTHOR_PUNC.add("noperiod");
        SEPARATORS.add("comma");
        SEPARATORS.add("and");
        SEPARATORS.add("colon");
        SEPARATORS.add("semicolon");
        SEPARATORS.add("sep");
        LAST_SEPARATORS.add("and");
        LAST_SEPARATORS.add("colon");
        LAST_SEPARATORS.add("semicolon");
        LAST_SEPARATORS.add("amp");
        LAST_SEPARATORS.add("oxford");
        LAST_SEPARATORS.add("lastsep");
    }
}

