/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BracesCorrector {
    private static final Pattern PATTERN_ESCAPED_CURLY_BRACES = Pattern.compile("(\\\\\\{)|(\\\\\\})");

    public static String apply(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = PATTERN_ESCAPED_CURLY_BRACES.matcher(input);
        String addedBraces = input;
        String c = matcher.replaceAll("");
        long diff = c.chars().filter(ch -> ch == 123).count() - c.chars().filter(ch -> ch == 125).count();
        while (diff != 0L) {
            if (diff < 0L) {
                addedBraces = "{" + addedBraces;
                ++diff;
                continue;
            }
            addedBraces = addedBraces + "}";
            --diff;
        }
        return addedBraces;
    }
}

