/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.VerifyingWriter;
import org.jabref.model.FieldChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaveSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveSession.class);
    protected boolean backup;
    protected final Charset encoding;
    protected final VerifyingWriter writer;
    private final List<FieldChange> undoableFieldChanges = new ArrayList<FieldChange>();

    protected SaveSession(Charset encoding, boolean backup, VerifyingWriter writer) {
        this.encoding = Objects.requireNonNull(encoding);
        this.backup = backup;
        this.writer = Objects.requireNonNull(writer);
    }

    public VerifyingWriter getWriter() {
        return this.writer;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setUseBackup(boolean useBackup) {
        this.backup = useBackup;
    }

    public abstract void commit(Path var1) throws SaveException;

    public void commit(String path) throws SaveException {
        this.commit(Paths.get(path, new String[0]));
    }

    public abstract void cancel();

    public List<FieldChange> getFieldChanges() {
        return this.undoableFieldChanges;
    }

    public void addFieldChanges(List<FieldChange> newUndoableFieldChanges) {
        this.undoableFieldChanges.addAll(newUndoableFieldChanges);
    }

    public void finalize(Path file) throws SaveException, IOException {
        this.getWriter().flush();
        this.getWriter().close();
        if (!this.getWriter().couldEncodeAll()) {
            LOGGER.warn("Could not encode...");
        }
        this.commit(file);
    }
}

