/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jabref.logic.exporter.GroupSerializer;
import org.jabref.logic.util.OS;
import org.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.metadata.ContentSelector;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.strings.StringUtil;

public class MetaDataSerializer {
    private MetaDataSerializer() {
    }

    public static Map<String, String> getSerializedStringMap(MetaData metaData, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        HashMap<String, List<String>> stringyMetaData = new HashMap<String, List<String>>();
        metaData.getSaveOrderConfig().ifPresent(saveOrderConfig -> stringyMetaData.put("saveOrderConfig", saveOrderConfig.getAsStringList()));
        metaData.getSaveActions().ifPresent(saveActions -> stringyMetaData.put("saveActions", saveActions.getAsStringList(OS.NEWLINE)));
        if (metaData.isProtected()) {
            stringyMetaData.put("protectedFlag", Collections.singletonList("true"));
        }
        stringyMetaData.putAll(MetaDataSerializer.serializeCiteKeyPattern(metaData, globalCiteKeyPattern));
        metaData.getMode().ifPresent(mode -> stringyMetaData.put("databaseType", Collections.singletonList(mode.getAsString())));
        metaData.getDefaultFileDirectory().ifPresent(path -> stringyMetaData.put("fileDirectory", Collections.singletonList(path.trim())));
        metaData.getUserFileDirectories().forEach((user, path) -> stringyMetaData.put("fileDirectory-" + user, Collections.singletonList(path.trim())));
        for (ContentSelector selector : metaData.getContentSelectorList()) {
            stringyMetaData.put("selector_" + selector.getFieldName(), selector.getValues());
        }
        Map<String, String> serializedMetaData = MetaDataSerializer.serializeMetaData(stringyMetaData);
        metaData.getGroups().filter(root -> root.getNumberOfChildren() > 0).ifPresent(root -> serializedMetaData.put("grouping", MetaDataSerializer.serializeGroups(root)));
        Map<String, List<String>> unknownMetaData = metaData.getUnknownMetaData();
        for (Map.Entry<String, List<String>> entry : unknownMetaData.entrySet()) {
            StringBuilder value = new StringBuilder();
            value.append(OS.NEWLINE);
            for (String line : entry.getValue()) {
                value.append(line.replaceAll(";", "\\\\;") + MetaData.SEPARATOR_STRING + OS.NEWLINE);
            }
            serializedMetaData.put(entry.getKey(), value.toString());
        }
        return serializedMetaData;
    }

    private static Map<String, String> serializeMetaData(Map<String, List<String>> stringyMetaData) {
        TreeMap<String, String> serializedMetaData = new TreeMap<String, String>();
        for (Map.Entry<String, List<String>> metaItem : stringyMetaData.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String dataItem : metaItem.getValue()) {
                stringBuilder.append(StringUtil.quote(dataItem, MetaData.SEPARATOR_STRING, '\\')).append(MetaData.SEPARATOR_STRING);
                if (!metaItem.getKey().equals("saveActions") || !"enabled".equals(dataItem) && !"disabled".equals(dataItem)) continue;
                stringBuilder.append(OS.NEWLINE);
            }
            String serializedItem = stringBuilder.toString();
            if (serializedItem.isEmpty() || MetaData.SEPARATOR_STRING.equals(serializedItem)) continue;
            serializedMetaData.put(metaItem.getKey(), serializedItem);
        }
        return serializedMetaData;
    }

    private static Map<String, List<String>> serializeCiteKeyPattern(MetaData metaData, GlobalBibtexKeyPattern globalCiteKeyPattern) {
        HashMap<String, List<String>> stringyPattern = new HashMap<String, List<String>>();
        AbstractBibtexKeyPattern citeKeyPattern = metaData.getCiteKeyPattern(globalCiteKeyPattern);
        for (String key : citeKeyPattern.getAllKeys()) {
            if (citeKeyPattern.isDefaultValue(key)) continue;
            ArrayList<String> data = new ArrayList<String>();
            data.add(citeKeyPattern.getValue(key).get(0));
            String metaDataKey = "keypattern_" + key;
            stringyPattern.put(metaDataKey, data);
        }
        if (citeKeyPattern.getDefaultValue() != null && !citeKeyPattern.getDefaultValue().isEmpty()) {
            ArrayList<String> data = new ArrayList<String>();
            data.add(citeKeyPattern.getDefaultValue().get(0));
            stringyPattern.put("keypatterndefault", data);
        }
        return stringyPattern;
    }

    private static String serializeGroups(GroupTreeNode root) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OS.NEWLINE);
        for (String groupNode : new GroupSerializer().serializeTree(root)) {
            stringBuilder.append(StringUtil.quote(groupNode, MetaData.SEPARATOR_STRING, '\\'));
            stringBuilder.append(MetaData.SEPARATOR_STRING);
            stringBuilder.append(OS.NEWLINE);
        }
        return stringBuilder.toString();
    }
}

