/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.logic.bibtex.LatexFieldFormatterPreferences;
import org.jabref.logic.bibtex.comparator.BibtexStringComparator;
import org.jabref.logic.bibtex.comparator.CrossRefEntryComparator;
import org.jabref.logic.bibtex.comparator.FieldComparator;
import org.jabref.logic.bibtex.comparator.FieldComparatorStack;
import org.jabref.logic.bibtex.comparator.IdComparator;
import org.jabref.logic.exporter.MetaDataSerializer;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.model.EntryTypes;
import org.jabref.model.FieldChange;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.model.cleanup.FieldFormatterCleanups;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.entry.CustomEntryType;
import org.jabref.model.entry.EntryType;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrderConfig;

public abstract class BibDatabaseWriter<E extends SaveSession> {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("(#[A-Za-z]+#)");
    private final SaveSessionFactory<E> saveSessionFactory;
    private E session;

    public BibDatabaseWriter(SaveSessionFactory<E> saveSessionFactory) {
        this.saveSessionFactory = saveSessionFactory;
    }

    private static List<FieldChange> applySaveActions(List<BibEntry> toChange, MetaData metaData) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        Optional<FieldFormatterCleanups> saveActions = metaData.getSaveActions();
        saveActions.ifPresent(actions2 -> {
            for (BibEntry entry : toChange) {
                changes.addAll(actions2.applySaveActions(entry));
            }
        });
        return changes;
    }

    public static List<FieldChange> applySaveActions(BibEntry entry, MetaData metaData) {
        return BibDatabaseWriter.applySaveActions(Arrays.asList(entry), metaData);
    }

    private static List<Comparator<BibEntry>> getSaveComparators(SavePreferences preferences, MetaData metaData) {
        ArrayList<Comparator<BibEntry>> comparators = new ArrayList<Comparator<BibEntry>>();
        Optional<SaveOrderConfig> saveOrder = BibDatabaseWriter.getSaveOrder(preferences, metaData);
        comparators.add(new CrossRefEntryComparator());
        if (!saveOrder.isPresent()) {
            comparators.add(new IdComparator());
        } else {
            comparators.add(new FieldComparator(saveOrder.get().sortCriteria[0]));
            comparators.add(new FieldComparator(saveOrder.get().sortCriteria[1]));
            comparators.add(new FieldComparator(saveOrder.get().sortCriteria[2]));
            comparators.add(new FieldComparator("bibtexkey"));
        }
        return comparators;
    }

    public static List<BibEntry> getSortedEntries(BibDatabaseContext bibDatabaseContext, List<BibEntry> entriesToSort, SavePreferences preferences) {
        Objects.requireNonNull(bibDatabaseContext);
        Objects.requireNonNull(entriesToSort);
        if (bibDatabaseContext.getMetaData() == null) {
            LinkedList<BibEntry> result = new LinkedList<BibEntry>();
            result.addAll(entriesToSort);
            return result;
        }
        List<Comparator<BibEntry>> comparators = BibDatabaseWriter.getSaveComparators(preferences, bibDatabaseContext.getMetaData());
        FieldComparatorStack<BibEntry> comparatorStack = new FieldComparatorStack<BibEntry>(comparators);
        ArrayList<BibEntry> sorted = new ArrayList<BibEntry>();
        sorted.addAll(entriesToSort);
        Collections.sort(sorted, comparatorStack);
        return sorted;
    }

    private static Optional<SaveOrderConfig> getSaveOrder(SavePreferences preferences, MetaData metaData) {
        if (preferences.isSaveInOriginalOrder()) {
            return Optional.empty();
        }
        if (preferences.getTakeMetadataSaveOrderInAccount().booleanValue()) {
            return metaData.getSaveOrderConfig();
        }
        return Optional.ofNullable(preferences.getSaveOrder());
    }

    public E saveDatabase(BibDatabaseContext bibDatabaseContext, SavePreferences preferences) throws SaveException {
        return this.savePartOfDatabase(bibDatabaseContext, (List<BibEntry>)bibDatabaseContext.getDatabase().getEntries(), preferences);
    }

    public E savePartOfDatabase(BibDatabaseContext bibDatabaseContext, List<BibEntry> entries, SavePreferences preferences) throws SaveException {
        this.session = this.saveSessionFactory.createSaveSession(preferences.getEncodingOrDefault(), preferences.getMakeBackup());
        Optional<String> sharedDatabaseIDOptional = bibDatabaseContext.getDatabase().getSharedDatabaseID();
        if (sharedDatabaseIDOptional.isPresent()) {
            this.writeDatabaseID(sharedDatabaseIDOptional.get());
        }
        TreeMap<String, EntryType> typesToWrite = new TreeMap<String, EntryType>();
        if (preferences.getSaveType() != SavePreferences.DatabaseSaveType.PLAIN_BIBTEX) {
            this.writePrelogue(bibDatabaseContext, preferences.getEncoding());
        }
        this.writePreamble(bibDatabaseContext.getDatabase().getPreamble().orElse(""));
        this.writeStrings(bibDatabaseContext.getDatabase(), preferences.isReformatFile(), preferences.getLatexFieldFormatterPreferences());
        List<BibEntry> sortedEntries = BibDatabaseWriter.getSortedEntries(bibDatabaseContext, entries, preferences);
        List<FieldChange> saveActionChanges = BibDatabaseWriter.applySaveActions(sortedEntries, bibDatabaseContext.getMetaData());
        ((SaveSession)this.session).addFieldChanges(saveActionChanges);
        for (BibEntry entry : sortedEntries) {
            if (!EntryTypes.getStandardType(entry.getType(), bibDatabaseContext.getMode()).isPresent()) {
                EntryTypes.getType(entry.getType(), bibDatabaseContext.getMode()).ifPresent(entryType -> typesToWrite.put(entryType.getName(), (EntryType)entryType));
            }
            this.writeEntry(entry, bibDatabaseContext.getMode(), preferences.isReformatFile(), preferences.getLatexFieldFormatterPreferences());
        }
        if (preferences.getSaveType() != SavePreferences.DatabaseSaveType.PLAIN_BIBTEX) {
            this.writeMetaData(bibDatabaseContext.getMetaData(), preferences.getGlobalCiteKeyPattern());
            this.writeEntryTypeDefinitions(typesToWrite);
        }
        this.writeEpilogue(bibDatabaseContext.getDatabase().getEpilog());
        try {
            ((SaveSession)this.session).getWriter().close();
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
        return this.session;
    }

    protected abstract void writePrelogue(BibDatabaseContext var1, Charset var2) throws SaveException;

    protected abstract void writeEntry(BibEntry var1, BibDatabaseMode var2, Boolean var3, LatexFieldFormatterPreferences var4) throws SaveException;

    protected abstract void writeEpilogue(String var1) throws SaveException;

    protected void writeMetaData(MetaData metaData, GlobalBibtexKeyPattern globalCiteKeyPattern) throws SaveException {
        Objects.requireNonNull(metaData);
        Map<String, String> serializedMetaData = MetaDataSerializer.getSerializedStringMap(metaData, globalCiteKeyPattern);
        for (Map.Entry<String, String> metaItem : serializedMetaData.entrySet()) {
            this.writeMetaDataItem(metaItem);
        }
    }

    protected abstract void writeMetaDataItem(Map.Entry<String, String> var1) throws SaveException;

    protected abstract void writePreamble(String var1) throws SaveException;

    protected abstract void writeDatabaseID(String var1) throws SaveException;

    private void writeStrings(BibDatabase database, Boolean reformatFile, LatexFieldFormatterPreferences latexFieldFormatterPreferences) throws SaveException {
        List strings = database.getStringKeySet().stream().map(database::getString).collect(Collectors.toList());
        strings.sort(new BibtexStringComparator(true));
        HashMap<String, BibtexString> remaining = new HashMap<String, BibtexString>();
        int maxKeyLength = 0;
        for (BibtexString string : strings) {
            remaining.put(string.getName(), string);
            maxKeyLength = Math.max(maxKeyLength, string.getName().length());
        }
        for (BibtexString.Type t : BibtexString.Type.values()) {
            boolean isFirstStringInType = true;
            for (BibtexString bs : strings) {
                if (!remaining.containsKey(bs.getName()) || bs.getType() != t) continue;
                this.writeString(bs, isFirstStringInType, remaining, maxKeyLength, reformatFile, latexFieldFormatterPreferences);
                isFirstStringInType = false;
            }
        }
    }

    protected void writeString(BibtexString bibtexString, boolean isFirstString, Map<String, BibtexString> remaining, int maxKeyLength, Boolean reformatFile, LatexFieldFormatterPreferences latexFieldFormatterPreferences) throws SaveException {
        Matcher m3;
        remaining.remove(bibtexString.getName());
        String content = bibtexString.getContent();
        while ((m3 = REFERENCE_PATTERN.matcher(content)).find()) {
            String foundLabel = m3.group(1);
            int restIndex = content.indexOf(foundLabel) + foundLabel.length();
            content = content.substring(restIndex);
            String label = foundLabel.substring(1, foundLabel.length() - 1);
            if (!remaining.containsKey(label)) continue;
            BibtexString referred = remaining.get(label);
            this.writeString(referred, isFirstString, remaining, maxKeyLength, reformatFile, latexFieldFormatterPreferences);
        }
        this.writeString(bibtexString, isFirstString, maxKeyLength, reformatFile, latexFieldFormatterPreferences);
    }

    protected abstract void writeString(BibtexString var1, boolean var2, int var3, Boolean var4, LatexFieldFormatterPreferences var5) throws SaveException;

    protected void writeEntryTypeDefinitions(Map<String, EntryType> types) throws SaveException {
        for (EntryType type : types.values()) {
            if (!(type instanceof CustomEntryType)) continue;
            this.writeEntryTypeDefinition((CustomEntryType)type);
        }
    }

    protected abstract void writeEntryTypeDefinition(CustomEntryType var1) throws SaveException;

    protected SaveSession getActiveSession() {
        return this.session;
    }

    public static interface SaveSessionFactory<E extends SaveSession> {
        public E createSaveSession(Charset var1, Boolean var2) throws SaveException;
    }
}

