/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveFilesCleanup
implements CleanupJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveFilesCleanup.class);
    private final BibDatabaseContext databaseContext;
    private final FileDirectoryPreferences fileDirectoryPreferences;
    private final String fileDirPattern;
    private LinkedFile singleFileFieldCleanup;

    public MoveFilesCleanup(BibDatabaseContext databaseContext, String fileDirPattern, FileDirectoryPreferences fileDirectoryPreferences, LayoutFormatterPreferences layoutPrefs) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.fileDirPattern = Objects.requireNonNull(fileDirPattern);
        this.fileDirectoryPreferences = Objects.requireNonNull(fileDirectoryPreferences);
    }

    public MoveFilesCleanup(BibDatabaseContext databaseContext, String fileDirPattern, FileDirectoryPreferences fileDirectoryPreferences, LayoutFormatterPreferences prefs, LinkedFile field2) {
        this(databaseContext, fileDirPattern, fileDirectoryPreferences, prefs);
        this.singleFileFieldCleanup = field2;
    }

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<LinkedFile> newFileList;
        List<LinkedFile> fileList;
        Optional<Path> firstExistingFileDir = this.databaseContext.getFirstExistingFileDir(this.fileDirectoryPreferences);
        if (!firstExistingFileDir.isPresent()) {
            return Collections.emptyList();
        }
        List<Path> paths = this.databaseContext.getFileDirectoriesAsPaths(this.fileDirectoryPreferences);
        String defaultFileDirectory = firstExistingFileDir.get().toString();
        Optional<Path> targetDirectory = FileHelper.expandFilenameAsPath(defaultFileDirectory, paths);
        if (!targetDirectory.isPresent()) {
            return Collections.emptyList();
        }
        if (this.singleFileFieldCleanup != null) {
            fileList = Arrays.asList(this.singleFileFieldCleanup);
            newFileList = entry.getFiles().stream().filter(name -> !name.equals(this.singleFileFieldCleanup)).collect(Collectors.toList());
        } else {
            newFileList = new ArrayList();
            fileList = entry.getFiles();
        }
        boolean changed = false;
        for (LinkedFile fileEntry : fileList) {
            Path newTargetFile;
            String oldFileName = fileEntry.getLink();
            Optional<Path> oldFile = fileEntry.findIn(paths);
            if (!oldFile.isPresent() || !Files.exists(oldFile.get(), new LinkOption[0])) {
                newFileList.add(fileEntry);
                continue;
            }
            String targetDirName = "";
            if (!this.fileDirPattern.isEmpty()) {
                targetDirName = FileUtil.createDirNameFromPattern(this.databaseContext.getDatabase(), entry, this.fileDirPattern);
            }
            if (Files.exists(newTargetFile = targetDirectory.get().resolve(targetDirName).resolve(oldFile.get().getFileName()), new LinkOption[0])) {
                newFileList.add(fileEntry);
                continue;
            }
            try {
                if (!Files.exists(newTargetFile, new LinkOption[0])) {
                    Files.createDirectories(newTargetFile, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("Could no create necessary target directoires for renaming", e);
            }
            if (!FileUtil.renameFile(oldFile.get(), newTargetFile, true)) continue;
            changed = true;
            String newEntryFilePath = Paths.get(defaultFileDirectory, new String[0]).relativize(newTargetFile).toString();
            LinkedFile newFileEntry = fileEntry;
            if (!oldFileName.equals(newTargetFile.toString())) {
                newFileEntry = new LinkedFile(fileEntry.getDescription(), newEntryFilePath, fileEntry.getFileType());
                changed = true;
            }
            newFileList.add(newFileEntry);
        }
        if (changed) {
            Optional<FieldChange> change = entry.setFiles(newFileList);
            if (change.isPresent()) {
                return Collections.singletonList(change.get());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

