/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.cleanup.FieldFormatterCleanups;

public class CleanupPreset {
    private final Set<CleanupStep> activeJobs;
    private final FieldFormatterCleanups formatterCleanups;

    public CleanupPreset(Set<CleanupStep> activeJobs) {
        this(activeJobs, new FieldFormatterCleanups(false, new ArrayList<FieldFormatterCleanup>()));
    }

    public CleanupPreset(CleanupStep activeJob) {
        this(EnumSet.of(activeJob));
    }

    public CleanupPreset(FieldFormatterCleanups formatterCleanups) {
        this(EnumSet.noneOf(CleanupStep.class), formatterCleanups);
    }

    public CleanupPreset(Set<CleanupStep> activeJobs, FieldFormatterCleanups formatterCleanups) {
        this.activeJobs = activeJobs;
        this.formatterCleanups = Objects.requireNonNull(formatterCleanups);
    }

    public boolean isCleanUpUpgradeExternalLinks() {
        return this.isActive(CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
    }

    public boolean isCleanUpDOI() {
        return this.isActive(CleanupStep.CLEAN_UP_DOI);
    }

    public boolean isCleanUpISSN() {
        return this.isActive(CleanupStep.CLEAN_UP_ISSN);
    }

    public boolean isFixFileLinks() {
        return this.isActive(CleanupStep.FIX_FILE_LINKS);
    }

    public boolean isMovePDF() {
        return this.isActive(CleanupStep.MOVE_PDF);
    }

    public boolean isMakePathsRelative() {
        return this.isActive(CleanupStep.MAKE_PATHS_RELATIVE);
    }

    public boolean isRenamePDF() {
        return this.isActive(CleanupStep.RENAME_PDF) != false || this.isActive(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS) != false;
    }

    public boolean isConvertToBiblatex() {
        return this.isActive(CleanupStep.CONVERT_TO_BIBLATEX);
    }

    public boolean isConvertToBibtex() {
        return this.isActive(CleanupStep.CONVERT_TO_BIBTEX);
    }

    public boolean isRenamePdfOnlyRelativePaths() {
        return this.isActive(CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
    }

    public Boolean isActive(CleanupStep step) {
        return this.activeJobs.contains((Object)step);
    }

    public FieldFormatterCleanups getFormatterCleanups() {
        return this.formatterCleanups;
    }

    public static enum CleanupStep {
        CLEAN_UP_DOI,
        MAKE_PATHS_RELATIVE,
        RENAME_PDF,
        RENAME_PDF_ONLY_RELATIVE_PATHS,
        CLEAN_UP_UPGRADE_EXTERNAL_LINKS,
        CONVERT_TO_BIBLATEX,
        CONVERT_TO_BIBTEX,
        MOVE_PDF,
        FIX_FILE_LINKS,
        CLEAN_UP_ISSN;

    }
}

