/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStyleGenerator;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.EntryRemovedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntryChangedEvent;

public class CitationStyleCache {
    private static final int CACHE_SIZE = 1024;
    private CitationStyle citationStyle;
    private final LoadingCache<BibEntry, String> citationStyleCache;

    public CitationStyleCache(BibDatabaseContext bibDatabaseContext) {
        this(bibDatabaseContext, CitationStyle.getDefault());
    }

    public CitationStyleCache(BibDatabaseContext bibDatabaseContext, CitationStyle citationStyle) {
        this.citationStyle = Objects.requireNonNull(citationStyle);
        this.citationStyleCache = CacheBuilder.newBuilder().maximumSize(1024L).build(new CacheLoader<BibEntry, String>(){

            @Override
            public String load(BibEntry entry) {
                return CitationStyleGenerator.generateCitation(entry, CitationStyleCache.this.getCitationStyle().getSource(), CitationStyleOutputFormat.HTML);
            }
        });
        bibDatabaseContext.getDatabase().registerListener(new BibDatabaseEntryListener());
    }

    public String getCitationFor(BibEntry entry) {
        return this.citationStyleCache.getUnchecked(entry);
    }

    public void setCitationStyle(CitationStyle citationStyle) {
        Objects.requireNonNull(citationStyle);
        if (!this.citationStyle.equals(citationStyle)) {
            this.citationStyle = citationStyle;
            this.citationStyleCache.invalidateAll();
        }
    }

    public CitationStyle getCitationStyle() {
        return this.citationStyle;
    }

    private class BibDatabaseEntryListener {
        private BibDatabaseEntryListener() {
        }

        @Subscribe
        public void listen(EntryChangedEvent entryChangedEvent) {
            CitationStyleCache.this.citationStyleCache.invalidate(entryChangedEvent.getBibEntry());
        }

        @Subscribe
        public void listen(EntryRemovedEvent entryRemovedEvent) {
            CitationStyleCache.this.citationStyleCache.invalidate(entryRemovedEvent.getBibEntry());
        }
    }
}

