/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class OnlyIntegerFormatter
extends TextFormatter<Integer> {
    public OnlyIntegerFormatter() {
        this(0);
    }

    public OnlyIntegerFormatter(Integer defaultValue) {
        super((StringConverter)new IntegerStringConverter(), (Object)defaultValue, (UnaryOperator)new IntegerFilter());
    }

    private static class IntegerFilter
    implements UnaryOperator<TextFormatter.Change> {
        private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d*");

        private IntegerFilter() {
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change aT) {
            return DIGIT_PATTERN.matcher(aT.getText()).matches() ? aT : null;
        }
    }
}

