/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.BasePanel;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;

public class UndoablePreambleChange
extends AbstractUndoableJabRefEdit {
    private final BibDatabase base;
    private final String oldValue;
    private final String newValue;
    private final BasePanel panel;

    public UndoablePreambleChange(BibDatabase base, BasePanel panel, String oldValue, String newValue) {
        this.base = base;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.panel = panel;
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change preamble", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        this.base.setPreamble(this.oldValue);
        this.panel.updatePreamble();
    }

    @Override
    public void redo() {
        super.redo();
        this.base.setPreamble(this.newValue);
        this.panel.updatePreamble();
    }
}

