/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import com.google.common.eventbus.EventBus;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.undo.AddUndoableActionEvent;
import org.jabref.logic.undo.UndoRedoEvent;

public class CountingUndoManager
extends UndoManager {
    private int unchangedPoint;
    private int current;
    private final EventBus eventBus = new EventBus();

    @Override
    public synchronized boolean addEdit(UndoableEdit edit) {
        ++this.current;
        boolean returnvalue = super.addEdit(edit);
        this.postAddUndoEvent();
        return returnvalue;
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();
        --this.current;
        this.postUndoRedoEvent();
    }

    @Override
    public synchronized void redo() throws CannotUndoException {
        super.redo();
        ++this.current;
        this.postUndoRedoEvent();
    }

    public synchronized void markUnchanged() {
        this.unchangedPoint = this.current;
    }

    public synchronized boolean hasChanged() {
        return this.current != this.unchangedPoint;
    }

    public void registerListener(Object object) {
        this.eventBus.register(object);
        this.postUndoRedoEvent();
    }

    public void unregisterListener(Object object) {
        this.eventBus.unregister(object);
    }

    public void postUndoRedoEvent() {
        boolean canUndo;
        boolean canRedo = this.canRedo();
        this.eventBus.post(new UndoRedoEvent(canUndo, (canUndo = this.canUndo()) ? this.getUndoPresentationName() : Localization.lang("Undo", new String[0]), canRedo, canRedo ? this.getRedoPresentationName() : Localization.lang("Redo", new String[0])));
    }

    private void postAddUndoEvent() {
        boolean canUndo;
        boolean canRedo = this.canRedo();
        this.eventBus.post(new AddUndoableActionEvent(canUndo, (canUndo = this.canUndo()) ? this.getUndoPresentationName() : Localization.lang("Undo", new String[0]), canRedo, canRedo ? this.getRedoPresentationName() : Localization.lang("Redo", new String[0])));
    }
}

