/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import java.util.Objects;
import javax.swing.Icon;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.specialfields.SpecialFieldAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.specialfields.SpecialField;
import org.jabref.model.entry.specialfields.SpecialFieldValue;

public class SpecialFieldViewModel {
    private final SpecialField field;

    public SpecialFieldViewModel(SpecialField field2) {
        Objects.requireNonNull(field2);
        this.field = field2;
    }

    public SpecialFieldAction getSpecialFieldAction(SpecialFieldValue value, JabRefFrame frame) {
        return new SpecialFieldAction(frame, this.field, value.getFieldValue().orElse(null), this.field.getValues().size() == 1, this.getLocalization());
    }

    public Icon getRepresentingIcon() {
        switch (this.field) {
            case PRINTED: {
                return IconTheme.JabRefIcon.PRINTED.getSmallIcon();
            }
            case PRIORITY: {
                return IconTheme.JabRefIcon.PRIORITY.getSmallIcon();
            }
            case QUALITY: {
                return IconTheme.JabRefIcon.QUALITY.getSmallIcon();
            }
            case RANKING: {
                return IconTheme.JabRefIcon.RANKING.getIcon();
            }
            case READ_STATUS: {
                return IconTheme.JabRefIcon.READ_STATUS.getSmallIcon();
            }
            case RELEVANCE: {
                return IconTheme.JabRefIcon.RELEVANCE.getSmallIcon();
            }
        }
        throw new IllegalArgumentException("There is no icon mapping for special field " + (Object)((Object)this.field));
    }

    public String getLocalization() {
        switch (this.field) {
            case PRINTED: {
                return Localization.lang("Printed", new String[0]);
            }
            case PRIORITY: {
                return Localization.lang("Priority", new String[0]);
            }
            case QUALITY: {
                return Localization.lang("Quality", new String[0]);
            }
            case RANKING: {
                return Localization.lang("Rank", new String[0]);
            }
            case READ_STATUS: {
                return Localization.lang("Read status", new String[0]);
            }
            case RELEVANCE: {
                return Localization.lang("Relevance", new String[0]);
            }
        }
        throw new IllegalArgumentException("There is no icon mapping for special field " + (Object)((Object)this.field));
    }
}

