/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.google.common.primitives.Ints;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.PreviewPanel;
import org.jabref.gui.customjfx.CustomJFXPanel;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.TestEntry;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewPrefsTab
extends JPanel
implements PrefsTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewPrefsTab.class);
    private SwingWorker<List<CitationStyle>, Void> discoverCitationStyleWorker;
    private final DefaultListModel<Object> availableModel = new DefaultListModel();
    private final DefaultListModel<Object> chosenModel = new DefaultListModel();
    private final JList<Object> available = new JList<Object>(this.availableModel);
    private final JList<Object> chosen = new JList<Object>(this.chosenModel);
    private final JButton btnRight = new JButton("\u00bb");
    private final JButton btnLeft = new JButton("\u00ab");
    private final JButton btnUp = new JButton(Localization.lang("Up", new String[0]));
    private final JButton btnDown = new JButton(Localization.lang("Down", new String[0]));
    private final JTextArea layout = new JTextArea("", 1, 1);
    private final JButton btnTest = new JButton(Localization.lang("Test", new String[0]));
    private final JButton btnDefault = new JButton(Localization.lang("Default", new String[0]));
    private final JScrollPane scrollPane = new JScrollPane(this.layout);

    public PreviewPrefsTab() {
        this.setupLogic();
        this.setupGui();
    }

    private void setupLogic() {
        this.chosen.getSelectionModel().addListSelectionListener(event -> {
            boolean selectionEmpty = ((ListSelectionModel)event.getSource()).isSelectionEmpty();
            this.btnLeft.setEnabled(!selectionEmpty);
            this.btnDown.setEnabled(!selectionEmpty);
            this.btnUp.setEnabled(!selectionEmpty);
        });
        this.available.getSelectionModel().addListSelectionListener(e -> this.btnRight.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty()));
        this.btnRight.addActionListener(event -> {
            for (Object object : this.available.getSelectedValuesList()) {
                this.availableModel.removeElement(object);
                this.chosenModel.addElement(object);
            }
        });
        this.btnLeft.addActionListener(event -> {
            for (Object object : this.chosen.getSelectedValuesList()) {
                this.availableModel.addElement(object);
                this.chosenModel.removeElement(object);
            }
        });
        this.btnUp.addActionListener(event -> {
            ArrayList<Integer> newSelectedIndices = new ArrayList<Integer>();
            for (int oldIndex : this.chosen.getSelectedIndices()) {
                boolean alreadyTaken = newSelectedIndices.contains(oldIndex - 1);
                int newIndex = oldIndex > 0 && !alreadyTaken ? oldIndex - 1 : oldIndex;
                this.chosenModel.add(newIndex, this.chosenModel.remove(oldIndex));
                newSelectedIndices.add(newIndex);
            }
            this.chosen.setSelectedIndices(Ints.toArray(newSelectedIndices));
        });
        this.btnDown.addActionListener(event -> {
            ArrayList<Integer> newSelectedIndices = new ArrayList<Integer>();
            int[] selectedIndices = this.chosen.getSelectedIndices();
            for (int i = selectedIndices.length - 1; i >= 0; --i) {
                int oldIndex = selectedIndices[i];
                boolean alreadyTaken = newSelectedIndices.contains(oldIndex + 1);
                int newIndex = oldIndex < this.chosenModel.getSize() - 1 && !alreadyTaken ? oldIndex + 1 : oldIndex;
                this.chosenModel.add(newIndex, this.chosenModel.remove(oldIndex));
                newSelectedIndices.add(newIndex);
            }
            this.chosen.setSelectedIndices(Ints.toArray(newSelectedIndices));
        });
        this.btnDefault.addActionListener(event -> this.layout.setText(Globals.prefs.getPreviewPreferences().getPreviewStyleDefault().replace("__NEWLINE__", "\n")));
        this.btnTest.addActionListener(event -> {
            try {
                PreviewPanel testPane = new PreviewPanel(null, null);
                testPane.setFixedLayout(this.layout.getText());
                testPane.setEntry(TestEntry.getTestEntry());
                JFXPanel container = CustomJFXPanel.wrap(new Scene((Parent)testPane));
                container.setPreferredSize(new Dimension(800, 350));
                JOptionPane.showMessageDialog(this, container, Localization.lang("Preview", new String[0]), -1);
            }
            catch (StringIndexOutOfBoundsException exception) {
                LOGGER.warn("Parsing error.", exception);
                JOptionPane.showMessageDialog(null, Localization.lang("Parsing error", new String[0]) + ": " + Localization.lang("illegal backslash expression", new String[0]) + ".\n" + exception.getMessage(), Localization.lang("Parsing error", new String[0]), 0);
            }
        });
    }

    private void setupGui() {
        JPanel chooseStyle = FormBuilder.create().columns("0:grow, $lcgap, pref, $lcgap, 0:grow", new Object[0]).rows("pref, $lg, fill:pref:grow, $lg, pref:grow, $lg, pref:grow, $lg, pref:grow", new Object[0]).padding(Paddings.DIALOG).addSeparator(Localization.lang("Current Preview", new String[0]), new Object[0]).xyw(1, 1, 5).add(this.available).xywh(1, 3, 1, 7).add(this.chosen).xywh(5, 3, 1, 7).add(this.btnRight).xy(3, 3, "fill, bottom").add(this.btnLeft).xy(3, 5, "fill, top").add(this.btnUp).xy(3, 7, "fill, bottom").add(this.btnDown).xy(3, 9, "fill, top").build();
        JPanel preview = FormBuilder.create().columns("pref:grow, $lcgap, pref, $lcgap, pref", new Object[0]).rows("pref, $lg, fill:pref:grow", new Object[0]).padding(Paddings.DIALOG).addSeparator(Localization.lang("Preview", new String[0]), new Object[0]).xy(1, 1).add(this.btnTest).xy(3, 1).add(this.btnDefault).xy(5, 1).add(this.scrollPane).xyw(1, 3, 5).build();
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)chooseStyle, "Center");
        this.add((Component)preview, "Last");
    }

    @Override
    public void setValues() {
        final PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences();
        this.chosenModel.clear();
        boolean isPreviewChosen = false;
        for (String style : previewPreferences.getPreviewCycle()) {
            Optional<CitationStyle> citationStyle = CitationStyle.createCitationStyleFromFile(style);
            if (citationStyle.isPresent()) {
                this.chosenModel.addElement(citationStyle.get());
                continue;
            }
            if (isPreviewChosen) {
                LOGGER.error("Preview is already in the list, something went wrong");
                continue;
            }
            isPreviewChosen = true;
            this.chosenModel.addElement(Localization.lang("Preview", new String[0]));
        }
        this.availableModel.clear();
        if (!isPreviewChosen) {
            this.availableModel.addElement(Localization.lang("Preview", new String[0]));
        }
        this.btnLeft.setEnabled(!this.chosen.isSelectionEmpty());
        this.btnRight.setEnabled(!this.available.isSelectionEmpty());
        this.btnUp.setEnabled(!this.chosen.isSelectionEmpty());
        this.btnDown.setEnabled(!this.chosen.isSelectionEmpty());
        if (this.discoverCitationStyleWorker != null) {
            this.discoverCitationStyleWorker.cancel(true);
        }
        this.discoverCitationStyleWorker = new SwingWorker<List<CitationStyle>, Void>(){

            @Override
            protected List<CitationStyle> doInBackground() throws Exception {
                return CitationStyle.discoverCitationStyles();
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    ((List)this.get()).stream().filter(style -> !previewPreferences.getPreviewCycle().contains(style.getFilePath())).sorted(Comparator.comparing(CitationStyle::getTitle)).forEach(PreviewPrefsTab.this.availableModel::addElement);
                    PreviewPrefsTab.this.btnRight.setEnabled(!PreviewPrefsTab.this.availableModel.isEmpty());
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("something went wrong while adding the discovered CitationStyles to the list ");
                }
            }
        };
        this.discoverCitationStyleWorker.execute();
        this.layout.setText(Globals.prefs.getPreviewPreferences().getPreviewStyle().replace("__NEWLINE__", "\n"));
    }

    @Override
    public void storeSettings() {
        ArrayList<String> styles = new ArrayList<String>();
        Enumeration<Object> elements = this.chosenModel.elements();
        while (elements.hasMoreElements()) {
            Object obj = elements.nextElement();
            if (obj instanceof CitationStyle) {
                styles.add(((CitationStyle)obj).getFilePath());
                continue;
            }
            if (!(obj instanceof String)) continue;
            styles.add("Preview");
        }
        PreviewPreferences previewPreferences = Globals.prefs.getPreviewPreferences().getBuilder().withPreviewCycle(styles).withPreviewStyle(this.layout.getText().replace("\n", "__NEWLINE__")).build();
        Globals.prefs.storePreviewPreferences(previewPreferences);
        for (BasePanel basePanel : JabRefGUI.getMainFrame().getBasePanelList()) {
            basePanel.getPreviewPanel().updateLayout();
        }
    }

    @Override
    public boolean validateSettings() {
        return !this.chosenModel.isEmpty();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry preview", new String[0]);
    }
}

