/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preftabs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.bibtexkeypattern.BibtexKeyPatternPanel;
import org.jabref.gui.preftabs.PrefsTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.bibtexkeypattern.GlobalBibtexKeyPattern;
import org.jabref.preferences.JabRefPreferences;

class BibtexKeyPatternPrefTab
extends BibtexKeyPatternPanel
implements PrefsTab {
    private final JabRefPreferences prefs;
    private final JCheckBox dontOverwrite = new JCheckBox(Localization.lang("Do not overwrite existing keys", new String[0]));
    private final JCheckBox warnBeforeOverwriting = new JCheckBox(Localization.lang("Warn before overwriting existing keys", new String[0]));
    private final JCheckBox generateOnSave = new JCheckBox(Localization.lang("Generate keys before saving (for entries without a key)", new String[0]));
    private final JCheckBox autoGenerateOnImport = new JCheckBox(Localization.lang("Generate keys for imported entries", new String[0]));
    private final JRadioButton letterStartA = new JRadioButton(Localization.lang("Ensure unique keys using letters (a, b, ...)", new String[0]));
    private final JRadioButton letterStartB = new JRadioButton(Localization.lang("Ensure unique keys using letters (b, c, ...)", new String[0]));
    private final JRadioButton alwaysAddLetter = new JRadioButton(Localization.lang("Always add letter (a, b, ...) to generated keys", new String[0]));
    private final JTextField keyPatternRegex = new JTextField(20);
    private final JTextField keyPatternReplacement = new JTextField(20);

    public BibtexKeyPatternPrefTab(JabRefPreferences prefs, BasePanel panel) {
        super(panel);
        this.prefs = prefs;
        this.appendKeyGeneratorSettings();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("defaultBibtexKeyPattern", this.defaultPat.getText());
        Globals.prefs.putBoolean("warnBeforeOverwritingKey", this.warnBeforeOverwriting.isSelected());
        Globals.prefs.putBoolean("avoidOverwritingKey", this.dontOverwrite.isSelected());
        Globals.prefs.put("KeyPatternRegex", this.keyPatternRegex.getText());
        Globals.prefs.put("KeyPatternReplacement", this.keyPatternReplacement.getText());
        Globals.prefs.putBoolean("generateKeysAfterInspection", this.autoGenerateOnImport.isSelected());
        Globals.prefs.putBoolean("generateKeysBeforeSaving", this.generateOnSave.isSelected());
        if (this.alwaysAddLetter.isSelected()) {
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", true);
        } else if (this.letterStartA.isSelected()) {
            Globals.prefs.putBoolean("keyGenFirstLetterA", true);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        } else {
            Globals.prefs.putBoolean("keyGenFirstLetterA", false);
            Globals.prefs.putBoolean("keyGenAlwaysAddLetter", false);
        }
        GlobalBibtexKeyPattern keypatterns = this.getKeyPatternAsGlobalBibtexKeyPattern();
        this.prefs.putKeyPattern(keypatterns);
    }

    private void appendKeyGeneratorSettings() {
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.letterStartA);
        bg.add(this.letterStartB);
        bg.add(this.alwaysAddLetter);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 8dlu, left:pref", "");
        JPanel pan = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Localization.lang("Key generator settings", new String[0]));
        builder.nextLine();
        builder.append(pan);
        builder.append(this.autoGenerateOnImport);
        builder.append(this.letterStartA);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.warnBeforeOverwriting);
        builder.append(this.letterStartB);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.dontOverwrite);
        builder.append(this.alwaysAddLetter);
        builder.nextLine();
        builder.append(pan);
        builder.append(this.generateOnSave);
        builder.nextLine();
        builder.append(pan);
        builder.append(Localization.lang("Replace (regular expression)", new String[0]) + ':');
        builder.append(Localization.lang("by", new String[0]) + ':');
        builder.nextLine();
        builder.append(pan);
        builder.append(this.keyPatternRegex);
        builder.append(this.keyPatternReplacement);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(builder.getPanel(), this.con);
        this.add(builder.getPanel());
        this.dontOverwrite.addChangeListener(e -> this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected()));
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public void setValues() {
        super.setValues(Globals.prefs.getKeyPattern());
        this.defaultPat.setText(Globals.prefs.get("defaultBibtexKeyPattern"));
        this.dontOverwrite.setSelected(Globals.prefs.getBoolean("avoidOverwritingKey"));
        this.generateOnSave.setSelected(Globals.prefs.getBoolean("generateKeysBeforeSaving"));
        this.autoGenerateOnImport.setSelected(Globals.prefs.getBoolean("generateKeysAfterInspection"));
        this.warnBeforeOverwriting.setSelected(Globals.prefs.getBoolean("warnBeforeOverwritingKey"));
        boolean prefAlwaysAddLetter = Globals.prefs.getBoolean("keyGenAlwaysAddLetter");
        boolean firstLetterA = Globals.prefs.getBoolean("keyGenFirstLetterA");
        if (prefAlwaysAddLetter) {
            this.alwaysAddLetter.setSelected(true);
        } else if (firstLetterA) {
            this.letterStartA.setSelected(true);
        } else {
            this.letterStartB.setSelected(true);
        }
        this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected());
        this.keyPatternRegex.setText(Globals.prefs.get("KeyPatternRegex"));
        this.keyPatternReplacement.setText(Globals.prefs.get("KeyPatternReplacement"));
    }

    @Override
    public String getTabName() {
        return Localization.lang("BibTeX key generator", new String[0]);
    }
}

