/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import javax.swing.JOptionPane;
import org.jabref.gui.BasePanel;
import org.jabref.gui.actions.BaseAction;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldName;

public class MergeWithFetchedEntryAction
implements BaseAction {
    private final BasePanel basePanel;

    public MergeWithFetchedEntryAction(BasePanel basePanel) {
        this.basePanel = basePanel;
    }

    @Override
    public void action() {
        if (this.basePanel.getMainTable().getSelectedEntries().size() == 1) {
            BibEntry originalEntry = this.basePanel.getMainTable().getSelectedEntries().get(0);
            new FetchAndMergeEntry(originalEntry, this.basePanel, FetchAndMergeEntry.SUPPORTED_FIELDS);
        } else {
            JOptionPane.showMessageDialog(this.basePanel.frame(), Localization.lang("This operation requires exactly one item to be selected.", new String[0]), Localization.lang("Merge entry with %0 information", FieldName.orFields(FieldName.getDisplayName("doi"), FieldName.getDisplayName("isbn"), FieldName.getDisplayName("eprint"))), 1);
        }
    }
}

