/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.io.File;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.jabref.JabRefGUI;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.importer.EntryFromFileCreator;
import org.jabref.model.entry.BibEntry;
import org.jabref.pdfimport.PdfImporter;

public class EntryFromPDFCreator
extends EntryFromFileCreator {
    public EntryFromPDFCreator(ExternalFileTypes externalFileTypes) {
        super(EntryFromPDFCreator.getPDFExternalFileType(externalFileTypes));
    }

    private static ExternalFileType getPDFExternalFileType(ExternalFileTypes externalFileTypes) {
        Optional<ExternalFileType> pdfFileType = externalFileTypes.getExternalFileTypeByExt("pdf");
        if (!pdfFileType.isPresent()) {
            return new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall", IconTheme.JabRefIcon.PDF_FILE.getSmallIcon());
        }
        return pdfFileType.get();
    }

    @Override
    public boolean accept(File f) {
        return f != null && f.getName().toUpperCase(Locale.ROOT).endsWith(".PDF");
    }

    @Override
    protected Optional<BibEntry> createBibtexEntry(File pdfFile) {
        if (!this.accept(pdfFile)) {
            return Optional.empty();
        }
        PdfImporter pi = new PdfImporter(JabRefGUI.getMainFrame(), JabRefGUI.getMainFrame().getCurrentBasePanel(), JabRefGUI.getMainFrame().getCurrentBasePanel().getMainTable(), -1);
        PdfImporter.ImportPdfFilesResult res = pi.importPdfFiles(Collections.singletonList(pdfFile.toString()));
        if (res.getEntries().size() == 1) {
            return Optional.of(res.getEntries().get(0));
        }
        return Optional.empty();
    }

    @Override
    public String getFormatName() {
        return "PDF";
    }
}

