/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.util.List;
import org.jabref.gui.groups.GroupSidePane;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupTreeNode;

class UndoableModifyGroup
extends AbstractUndoableJabRefEdit {
    private final GroupSidePane groupSidePane;
    private final AbstractGroup m_oldGroupBackup;
    private final AbstractGroup m_newGroupBackup;
    private final GroupTreeNode m_groupsRootHandle;
    private final List<Integer> m_pathToNode;

    public UndoableModifyGroup(GroupSidePane gs, GroupTreeNodeViewModel groupsRoot, GroupTreeNodeViewModel node, AbstractGroup newGroup) {
        this.groupSidePane = gs;
        this.m_oldGroupBackup = node.getNode().getGroup().deepCopy();
        this.m_newGroupBackup = newGroup.deepCopy();
        this.m_pathToNode = node.getNode().getIndexedPathFromRoot();
        this.m_groupsRootHandle = groupsRoot.getNode();
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("modify group", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        ((GroupTreeNode)this.m_groupsRootHandle.getDescendant(this.m_pathToNode).get()).setGroup(this.m_oldGroupBackup.deepCopy());
    }

    @Override
    public void redo() {
        super.redo();
        ((GroupTreeNode)this.m_groupsRootHandle.getDescendant(this.m_pathToNode).get()).setGroup(this.m_newGroupBackup.deepCopy());
    }
}

