/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.google.common.base.Enums;
import com.google.common.eventbus.Subscribe;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.Dragboard;
import javafx.scene.paint.Color;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.IconTheme;
import org.jabref.gui.StateManager;
import org.jabref.gui.groups.DroppingMouseLocation;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntryEvent;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.AutomaticGroup;
import org.jabref.model.groups.GroupEntryChanger;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.strings.StringUtil;

public class GroupNodeViewModel {
    private final String displayName;
    private final boolean isRoot;
    private final ObservableList<GroupNodeViewModel> children;
    private final BibDatabaseContext databaseContext;
    private final StateManager stateManager;
    private final GroupTreeNode groupNode;
    private final SimpleIntegerProperty hits;
    private final SimpleBooleanProperty hasChildren;
    private final SimpleBooleanProperty expandedProperty = new SimpleBooleanProperty();
    private final BooleanBinding anySelectedEntriesMatched;
    private final BooleanBinding allSelectedEntriesMatched;
    private final TaskExecutor taskExecutor;

    public GroupNodeViewModel(BibDatabaseContext databaseContext, StateManager stateManager, TaskExecutor taskExecutor, GroupTreeNode groupNode) {
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.stateManager = Objects.requireNonNull(stateManager);
        this.groupNode = Objects.requireNonNull(groupNode);
        LatexToUnicodeFormatter formatter = new LatexToUnicodeFormatter();
        this.displayName = formatter.format(groupNode.getName());
        this.isRoot = groupNode.isRoot();
        if (groupNode.getGroup() instanceof AutomaticGroup) {
            AutomaticGroup automaticGroup = (AutomaticGroup)groupNode.getGroup();
            this.children = automaticGroup.createSubgroups(databaseContext.getDatabase().getEntries()).stream().map(this::toViewModel).sorted((group1, group2) -> group1.getDisplayName().compareToIgnoreCase(group2.getDisplayName())).collect(Collectors.toCollection(FXCollections::observableArrayList));
        } else {
            this.children = BindingsHelper.mapBacked(groupNode.getChildren(), this::toViewModel);
        }
        this.hasChildren = new SimpleBooleanProperty();
        this.hasChildren.bind((ObservableValue)Bindings.isNotEmpty(this.children));
        this.hits = new SimpleIntegerProperty(0);
        this.calculateNumberOfMatches();
        this.expandedProperty.set(groupNode.getGroup().isExpanded());
        this.expandedProperty.addListener((observable, oldValue, newValue) -> groupNode.getGroup().setExpanded((boolean)newValue));
        databaseContext.getDatabase().registerListener(this);
        ObservableList<Boolean> selectedEntriesMatchStatus = EasyBind.map(stateManager.getSelectedEntries(), groupNode::matches);
        this.anySelectedEntriesMatched = BindingsHelper.any(selectedEntriesMatchStatus, matched -> matched);
        this.allSelectedEntriesMatched = BindingsHelper.all(selectedEntriesMatchStatus, matched -> matched);
    }

    public GroupNodeViewModel(BibDatabaseContext databaseContext, StateManager stateManager, TaskExecutor taskExecutor, AbstractGroup group) {
        this(databaseContext, stateManager, taskExecutor, new GroupTreeNode(group));
    }

    static GroupNodeViewModel getAllEntriesGroup(BibDatabaseContext newDatabase, StateManager stateManager, TaskExecutor taskExecutor) {
        return new GroupNodeViewModel(newDatabase, stateManager, taskExecutor, DefaultGroupsFactory.getAllEntriesGroup());
    }

    private GroupNodeViewModel toViewModel(GroupTreeNode child) {
        return new GroupNodeViewModel(this.databaseContext, this.stateManager, this.taskExecutor, child);
    }

    public List<FieldChange> addEntriesToGroup(List<BibEntry> entries) {
        return this.groupNode.addEntriesToGroup(entries);
    }

    public SimpleBooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public BooleanBinding anySelectedEntriesMatchedProperty() {
        return this.anySelectedEntriesMatched;
    }

    public BooleanBinding allSelectedEntriesMatchedProperty() {
        return this.allSelectedEntriesMatched;
    }

    public SimpleBooleanProperty hasChildrenProperty() {
        return this.hasChildren;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getDescription() {
        return this.groupNode.getGroup().getDescription().orElse("");
    }

    public SimpleIntegerProperty getHits() {
        return this.hits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupNodeViewModel that = (GroupNodeViewModel)o;
        return this.groupNode.equals(that.groupNode);
    }

    public String toString() {
        return "GroupNodeViewModel{displayName='" + this.displayName + '\'' + ", isRoot=" + this.isRoot + ", icon='" + this.getIcon() + '\'' + ", children=" + this.children + ", databaseContext=" + this.databaseContext + ", groupNode=" + this.groupNode + ", hits=" + this.hits + '}';
    }

    public int hashCode() {
        return this.groupNode.hashCode();
    }

    public MaterialDesignIcon getIcon() {
        Optional<String> iconName = this.groupNode.getGroup().getIconName();
        return iconName.flatMap(this::parseIcon).orElse(IconTheme.JabRefIcon.DEFAULT_GROUP_ICON.getUnderlyingIcon());
    }

    private Optional<MaterialDesignIcon> parseIcon(String iconCode) {
        return Enums.getIfPresent(MaterialDesignIcon.class, iconCode.toUpperCase(Locale.ENGLISH)).toJavaUtil();
    }

    public ObservableList<GroupNodeViewModel> getChildren() {
        return this.children;
    }

    public GroupTreeNode getGroupNode() {
        return this.groupNode;
    }

    @Subscribe
    public void listen(EntryEvent entryEvent) {
        this.calculateNumberOfMatches();
    }

    private void calculateNumberOfMatches() {
        BackgroundTask.wrap(() -> this.groupNode.calculateNumberOfMatches(this.databaseContext.getDatabase())).onSuccess(arg_0 -> ((SimpleIntegerProperty)this.hits).setValue(arg_0)).executeWith(this.taskExecutor);
    }

    public GroupTreeNode addSubgroup(AbstractGroup subgroup) {
        return this.groupNode.addSubgroup(subgroup);
    }

    void toggleExpansion() {
        this.expandedProperty().set(!this.expandedProperty().get());
    }

    boolean isMatchedBy(String searchString) {
        return StringUtil.isBlank(searchString) || StringUtil.containsIgnoreCase(this.getDisplayName(), searchString);
    }

    public Color getColor() {
        return this.groupNode.getGroup().getColor().orElse(IconTheme.getDefaultColor());
    }

    public String getPath() {
        return this.groupNode.getPath();
    }

    public Optional<GroupNodeViewModel> getChildByPath(String pathToSource) {
        return this.groupNode.getChildByPath(pathToSource).map(this::toViewModel);
    }

    public boolean acceptableDrop(Dragboard dragboard) {
        boolean canDropOtherGroup = dragboard.hasContent(DragAndDropDataFormats.GROUP);
        boolean canDropEntries = dragboard.hasContent(DragAndDropDataFormats.ENTRIES) && this.groupNode.getGroup() instanceof GroupEntryChanger;
        return canDropOtherGroup || canDropEntries;
    }

    public void moveTo(GroupNodeViewModel target) {
        this.getGroupNode().moveTo(target.getGroupNode());
    }

    public void moveTo(GroupTreeNode target, int targetIndex) {
        this.getGroupNode().moveTo(target, targetIndex);
    }

    public Optional<GroupTreeNode> getParent() {
        return this.groupNode.getParent();
    }

    public void draggedOn(GroupNodeViewModel target, DroppingMouseLocation mouseLocation) {
        Optional<GroupTreeNode> targetParent = target.getParent();
        if (targetParent.isPresent()) {
            int sourceIndex;
            int targetIndex = target.getPositionInParent();
            if (targetParent.equals(this.getParent()) && (sourceIndex = this.getPositionInParent()) < targetIndex) {
                --targetIndex;
            }
            switch (mouseLocation) {
                case BOTTOM: {
                    this.moveTo(targetParent.get(), targetIndex + 1);
                    break;
                }
                case CENTER: {
                    this.moveTo(target);
                    break;
                }
                case TOP: {
                    this.moveTo(targetParent.get(), targetIndex);
                }
            }
        } else {
            this.moveTo(target);
        }
    }

    private int getPositionInParent() {
        return this.groupNode.getPositionInParent();
    }
}

