/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jabref.Globals;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.fieldeditors.FieldEditor;
import org.jabref.gui.fieldeditors.FieldEditorFocusListener;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.component.JTextFieldWithPlaceholder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextField
extends JTextFieldWithPlaceholder
implements FieldEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextField.class);
    private final String fieldName;
    private UndoManager undo;

    public TextField(String fieldName, String content, boolean changeColorOnFocus) {
        this(fieldName, content, changeColorOnFocus, "");
    }

    public TextField(String fieldName, String content, boolean changeColorOnFocus, String title) {
        super(content, title);
        this.setupPasteListener();
        this.setupUndoRedo();
        this.updateFont();
        this.addFocusListener(Globals.getFocusListener());
        if (changeColorOnFocus) {
            this.addFocusListener(new FieldEditorFocusListener());
        }
        this.fieldName = fieldName;
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void append(String text) {
        this.setText(this.getText() + text);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JComponent getPane() {
        return this;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.activeBackgroundColor);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackgroundColor(GUIGlobals.invalidFieldBackgroundColor);
    }

    private void setBackgroundColor(Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBackground(color);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this.setBackground(color));
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.info("Problem setting background color", e);
            }
        }
    }

    private void updateFont() {
        this.setFont(GUIGlobals.currentFont);
    }

    @Override
    public void paste(String textToInsert) {
        this.replaceSelection(textToInsert);
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    private void setupPasteListener() {
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.PASTE), "paste");
    }

    private void setupUndoRedo() {
        this.undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(evt -> this.undo.addEdit(evt.getEdit()));
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TextField.this.undo.canUndo()) {
                        TextField.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.UNDO), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TextField.this.undo.canRedo()) {
                        TextField.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.REDO), "Redo");
    }
}

