/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.beans.binding.Bindings;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.LinkedEntriesEditorViewModel;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.component.TagBar;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.ParsedEntryLink;

public class LinkedEntriesEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final LinkedEntriesEditorViewModel viewModel;
    @FXML
    private TagBar<ParsedEntryLink> linkedEntriesBar;

    public LinkedEntriesEditor(String fieldName, BibDatabaseContext databaseContext, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        this.viewModel = new LinkedEntriesEditorViewModel(fieldName, suggestionProvider, databaseContext, fieldCheckers);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.linkedEntriesBar.setStringConverter(this.viewModel.getStringConverter());
        this.linkedEntriesBar.setOnTagClicked((parsedEntryLink, mouseEvent) -> this.viewModel.jumpToEntry((ParsedEntryLink)parsedEntryLink));
        AutoCompletionTextInputBinding.autoComplete((TextInputControl)this.linkedEntriesBar.getInputTextField(), this.viewModel::complete, this.viewModel.getStringConverter());
        Bindings.bindContentBidirectional(this.linkedEntriesBar.tagsProperty(), this.viewModel.linkedEntriesProperty());
    }

    public LinkedEntriesEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

