/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.customentrytypes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.l10n.Localization;

class FieldSetComponent
extends JPanel {
    protected final JList<String> list;
    protected DefaultListModel<String> listModel;
    protected final JButton remove;
    protected final GridBagLayout gbl = new GridBagLayout();
    protected final GridBagConstraints con = new GridBagConstraints();
    protected final boolean forceLowerCase;
    protected boolean changesMade;
    private final Set<ActionListener> additionListeners = new HashSet<ActionListener>();
    private final JScrollPane sp;
    private JComboBox<String> sel;
    private JTextField input;
    private final JButton add;
    private JButton up;
    private JButton down;
    private final Set<ListDataListener> modelListeners = new HashSet<ListDataListener>();

    public FieldSetComponent(String title, List<String> fields, List<String> preset, boolean arrows, boolean forceLowerCase) {
        this(title, fields, preset, Localization.lang("Add", new String[0]), Localization.lang("Remove", new String[0]), arrows, forceLowerCase);
    }

    FieldSetComponent(String title, List<String> fields, boolean arrows, boolean forceLowerCase) {
        this(title, fields, null, Localization.lang("Add", new String[0]), Localization.lang("Remove", new String[0]), arrows, forceLowerCase);
    }

    private FieldSetComponent(String title, List<String> fields, List<String> preset, String addText, String removeText, boolean arrows, boolean forceLowerCase) {
        this.forceLowerCase = forceLowerCase;
        this.add = new JButton(addText);
        this.remove = new JButton(removeText);
        this.listModel = new DefaultListModel();
        JLabel title1 = null;
        if (title != null) {
            title1 = new JLabel(title);
        }
        for (String field2 : fields) {
            this.listModel.addElement(field2);
        }
        this.list = new JList<String>(this.listModel);
        this.list.setSelectionMode(2);
        this.add.addActionListener(e -> {
            if (this.sel != null && this.sel.getSelectedItem() != null) {
                String s2 = this.sel.getSelectedItem().toString();
                this.addField(s2);
            } else if (this.input != null && !"".equals(this.input.getText())) {
                this.addField(this.input.getText());
            }
        });
        this.remove.addActionListener(e -> this.removeSelected());
        this.setLayout(this.gbl);
        this.con.insets = new Insets(1, 1, 1, 1);
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        if (title1 != null) {
            this.gbl.setConstraints(title1, this.con);
            this.add(title1);
        }
        this.con.weighty = 1.0;
        this.sp = new JScrollPane(this.list, 20, 31);
        this.gbl.setConstraints(this.sp, this.con);
        this.add(this.sp);
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        if (arrows) {
            this.con.weightx = 0.0;
            this.up = new JButton(IconTheme.JabRefIcon.UP.getSmallIcon());
            this.down = new JButton(IconTheme.JabRefIcon.DOWN.getSmallIcon());
            this.up.addActionListener(e -> this.move(-1));
            this.down.addActionListener(e -> this.move(1));
            this.up.setToolTipText(Localization.lang("Move up", new String[0]));
            this.down.setToolTipText(Localization.lang("Move down", new String[0]));
            this.gbl.setConstraints(this.up, this.con);
            this.add(this.up);
            this.gbl.setConstraints(this.down, this.con);
            this.add(this.down);
            this.con.weightx = 0.0;
        }
        Component strut = Box.createHorizontalStrut(5);
        this.gbl.setConstraints(strut, this.con);
        this.add(strut);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.remove, this.con);
        this.add(this.remove);
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        if (preset == null) {
            this.input = new JTextField(20);
            this.input.addActionListener(e -> this.addField(this.input.getText()));
            this.gbl.setConstraints(this.input, this.con);
            this.add(this.input);
        } else {
            this.sel = new JComboBox<String>(preset.toArray(new String[preset.size()]));
            this.sel.setEditable(true);
            this.gbl.setConstraints(this.sel, this.con);
            this.add(this.sel);
        }
        this.con.gridwidth = 0;
        this.con.weighty = 0.0;
        this.con.weightx = 0.5;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.add, this.con);
        this.add(this.add);
        FieldListFocusListener<String> fieldListFocusListener = new FieldListFocusListener<String>(this.list);
        this.list.addFocusListener(fieldListFocusListener);
    }

    public void setListSelectionMode(int mode) {
        this.list.setSelectionMode(mode);
    }

    public void selectField(String fieldName) {
        int idx = this.listModel.indexOf(fieldName);
        if (idx >= 0) {
            this.list.setSelectedIndex(idx);
        }
        JViewport viewport = this.sp.getViewport();
        Rectangle rectangle = this.list.getCellBounds(idx, idx);
        if (rectangle != null) {
            viewport.scrollRectToVisible(rectangle);
        }
    }

    public String getFirstSelected() {
        return this.list.getSelectedValue();
    }

    @Override
    public void setEnabled(boolean en) {
        if (this.input != null) {
            this.input.setEnabled(en);
        }
        if (this.sel != null) {
            this.sel.setEnabled(en);
        }
        if (this.up != null) {
            this.up.setEnabled(en);
            this.down.setEnabled(en);
        }
        this.add.setEnabled(en);
        this.remove.setEnabled(en);
    }

    public Set<String> getFields() {
        LinkedHashSet<String> res = new LinkedHashSet<String>(this.listModel.getSize());
        Enumeration<String> elements = this.listModel.elements();
        while (elements.hasMoreElements()) {
            res.add(elements.nextElement());
        }
        return res;
    }

    protected void addField(String str) {
        String s2 = str.trim();
        if (this.forceLowerCase) {
            s2 = s2.toLowerCase(Locale.ROOT);
        }
        if ("".equals(s2) || this.listModel.contains(s2)) {
            return;
        }
        String testString = BibtexKeyGenerator.cleanKey(s2, Globals.prefs.getBoolean("enforceLegalBibtexKey"));
        if (!testString.equals(s2) || s2.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Localization.lang("Field names are not allowed to contain white space or the following characters", new String[0]) + ": # { } ~ , ^ &", Localization.lang("Error", new String[0]), 0);
            return;
        }
        this.addFieldUncritically(s2);
    }

    protected void addFieldUncritically(String s2) {
        this.listModel.addElement(s2);
        this.changesMade = true;
        for (ActionListener additionListener : this.additionListeners) {
            additionListener.actionPerformed(new ActionEvent(this, 0, s2));
        }
    }

    protected void removeSelected() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < selected.length; ++i) {
            this.listModel.removeElementAt(selected[selected.length - 1 - i]);
        }
    }

    public void setFields(Set<String> fields) {
        DefaultListModel<String> newListModel = new DefaultListModel<String>();
        for (String field2 : fields) {
            newListModel.addElement(field2);
        }
        this.listModel = newListModel;
        for (ListDataListener modelListener : this.modelListeners) {
            newListModel.addListDataListener(modelListener);
        }
        this.list.setModel(newListModel);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.list.addListSelectionListener(l);
    }

    public void addAdditionActionListener(ActionListener l) {
        this.additionListeners.add(l);
    }

    public void addListDataListener(ListDataListener l) {
        this.listModel.addListDataListener(l);
        this.modelListeners.add(l);
    }

    private void move(int dy) {
        int oldIdx = this.list.getSelectedIndex();
        if (oldIdx < 0) {
            return;
        }
        String o = this.listModel.get(oldIdx);
        int newInd = Math.max(0, Math.min(this.listModel.size() - 1, oldIdx + dy));
        this.listModel.remove(oldIdx);
        this.listModel.add(newInd, o);
        this.list.setSelectedIndex(newInd);
    }

    protected class FieldListFocusListener<T>
    implements FocusListener {
        private final JList<T> list;

        public FieldListFocusListener(JList<T> list) {
            this.list = list;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.list.getSelectedValue() == null) {
                this.list.setSelectedIndex(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

