/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jabref.gui.BasePanel;
import org.jabref.gui.collab.ChangeViewModel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableInsertString;
import org.jabref.gui.undo.UndoableStringChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.KeyCollisionException;
import org.jabref.model.entry.BibtexString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StringNameChangeViewModel
extends ChangeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringNameChangeViewModel.class);
    private final BibtexString string;
    private final String mem;
    private final String disk;
    private final String content;
    private final BibtexString tmpString;

    public StringNameChangeViewModel(BibtexString string, BibtexString tmpString, String mem, String disk) {
        super(Localization.lang("Renamed string", new String[0]) + ": '" + tmpString.getName() + '\'');
        this.tmpString = tmpString;
        this.string = string;
        this.content = tmpString.getContent();
        this.mem = mem;
        this.disk = disk;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibDatabase secondary, NamedCompound undoEdit) {
        BibtexString bs;
        if (panel.getDatabase().hasStringLabel(this.disk)) {
            LOGGER.info("Cannot rename string '" + this.mem + "' to '" + this.disk + "' because the name is already in use.");
        }
        if (this.string == null) {
            bs = new BibtexString(this.disk, this.content);
            try {
                panel.getDatabase().addString(bs);
                undoEdit.addEdit(new UndoableInsertString(panel, panel.getDatabase(), bs));
            }
            catch (KeyCollisionException ex) {
                LOGGER.info("Error: could not add string '" + bs.getName() + "': " + ex.getMessage(), ex);
            }
        } else {
            this.string.setName(this.disk);
            undoEdit.addEdit(new UndoableStringChange(panel, this.string, true, this.mem, this.disk));
        }
        if (this.tmpString == null) {
            bs = new BibtexString(this.disk, this.content);
            secondary.addString(bs);
        } else {
            this.tmpString.setName(this.disk);
        }
        return true;
    }

    @Override
    public JComponent description() {
        return new JLabel(this.disk + " : " + this.content);
    }
}

