/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.bibtexkeypattern;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.bibtexkeypattern.BibtexKeyPatternPanel;
import org.jabref.gui.keyboard.KeyBinder;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.bibtexkeypattern.AbstractBibtexKeyPattern;
import org.jabref.model.metadata.MetaData;

public class BibtexKeyPatternDialog
extends JabRefDialog {
    private MetaData metaData;
    private BasePanel panel;
    private final BibtexKeyPatternPanel bibtexKeyPatternPanel;

    public BibtexKeyPatternDialog(JabRefFrame parent, BasePanel panel) {
        super((Frame)parent, Localization.lang("BibTeX key patterns", new String[0]), true, BibtexKeyPatternDialog.class);
        this.bibtexKeyPatternPanel = new BibtexKeyPatternPanel(panel);
        this.setPanel(panel);
        this.init();
    }

    public void setPanel(BasePanel panel) {
        this.panel = panel;
        this.metaData = panel.getBibDatabaseContext().getMetaData();
        AbstractBibtexKeyPattern keypatterns = this.metaData.getCiteKeyPattern(Globals.prefs.getKeyPattern());
        this.bibtexKeyPatternPanel.setValues(keypatterns);
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.bibtexKeyPatternPanel, "Center");
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton();
        JPanel lower = new JPanel();
        lower.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder bb = new ButtonBarBuilder(lower);
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        this.getContentPane().add((Component)lower, "South");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setPreferredSize(new Dimension(500, 600));
        this.pack();
        ok.addActionListener(e -> {
            this.metaData.setCiteKeyPattern(this.bibtexKeyPatternPanel.getKeyPatternAsDatabaseBibtexKeyPattern());
            this.panel.markNonUndoableBaseChanged();
            this.dispose();
        });
        final BibtexKeyPatternDialog dialog = this;
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        cancel.setAction(cancelAction);
        cancel.setText(Localization.lang("Cancel", new String[0]));
        KeyBinder.bindCloseDialogKeyToCancelAction(this.getRootPane(), cancelAction);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            super.setVisible(visible);
        }
    }
}

