/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.specialfields.SpecialFieldsUtils;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.strings.StringUtil;

public class ManageKeywordsAction
extends MnemonicAwareAction {
    private final JabRefFrame frame;
    private final KeywordList sortedKeywordsOfAllEntriesBeforeUpdateByUser = new KeywordList();
    private JDialog diag;
    private DefaultListModel<Keyword> keywordListModel;
    private JRadioButton intersectKeywords;
    private JRadioButton mergeKeywords;
    private boolean canceled;

    public ManageKeywordsAction(JabRefFrame frame) {
        this.putValue("Name", Localization.menuTitle("Manage keywords", new String[0]));
        this.frame = frame;
    }

    private void createDialog() {
        if (this.diag != null) {
            return;
        }
        JTextField keyword = new JTextField();
        this.keywordListModel = new DefaultListModel();
        JList<Keyword> keywordList = new JList<Keyword>(this.keywordListModel);
        keywordList.setVisibleRowCount(8);
        JScrollPane kPane = new JScrollPane(keywordList);
        this.diag = new JDialog(this.frame, Localization.lang("Manage keywords", new String[0]), true);
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        JButton add = new JButton(Localization.lang("Add", new String[0]));
        JButton remove = new JButton(Localization.lang("Remove", new String[0]));
        JButton replace = new JButton(Localization.lang("Replace", new String[0]));
        JButton join = new JButton(Localization.lang("Join", new String[0]));
        join.setToolTipText(Localization.lang("Joins selected keywords and deletes selected keywords.", new String[0]));
        keywordList.setVisibleRowCount(10);
        this.intersectKeywords = new JRadioButton(Localization.lang("Display keywords appearing in ALL entries", new String[0]));
        this.mergeKeywords = new JRadioButton(Localization.lang("Display keywords appearing in ANY entry", new String[0]));
        ButtonGroup group = new ButtonGroup();
        group.add(this.intersectKeywords);
        group.add(this.mergeKeywords);
        ActionListener stateChanged = e -> this.fillKeyWordList();
        this.intersectKeywords.addActionListener(stateChanged);
        this.mergeKeywords.addActionListener(stateChanged);
        this.intersectKeywords.setSelected(true);
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:200dlu:grow, pref, fill:pref", "pref, 2dlu, pref, 1dlu, pref, 2dlu, fill:100dlu:grow, 4dlu, pref, 4dlu, pref, "));
        builder.addSeparator(Localization.lang("Keywords of selected entries", new String[0]), new Object[0]).xyw(1, 1, 3);
        builder.add(this.intersectKeywords).xyw(1, 3, 3);
        builder.add(this.mergeKeywords).xyw(1, 5, 3);
        builder.add(kPane).xywh(1, 7, 1, 3);
        builder.add(join).xy(2, 9);
        builder.add(replace).xy(3, 9);
        builder.add(keyword).xy(1, 11);
        builder.add(add).xy(2, 11);
        builder.add(remove).xy(3, 11);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ok.addActionListener(e -> {
            this.canceled = false;
            this.diag.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageKeywordsAction.this.canceled = true;
                ManageKeywordsAction.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        final ActionListener addActionListener = arg0 -> this.addButtonActionListener(keyword);
        add.addActionListener(addActionListener);
        final ActionListener removeActionListener = arg0 -> {
            List values = keywordList.getSelectedValuesList();
            for (Keyword val : values) {
                this.keywordListModel.removeElement(val);
            }
        };
        remove.addActionListener(removeActionListener);
        ActionListener joinActionListener = arg0 -> {
            List values = keywordList.getSelectedValuesList();
            String joinedKeyword = values.stream().map(currentKeyword -> currentKeyword.get()).collect(Collectors.joining(" "));
            this.addKeywordToKeywordListModel(joinedKeyword);
            for (Keyword val : values) {
                this.keywordListModel.removeElement(val);
            }
        };
        join.addActionListener(joinActionListener);
        ActionListener replaceActionListener = arg0 -> {
            List values = keywordList.getSelectedValuesList();
            for (Keyword val : values) {
                this.keywordListModel.removeElement(val);
            }
            this.addButtonActionListener(keyword);
        };
        replace.addActionListener(replaceActionListener);
        keywordList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 127) {
                    removeActionListener.actionPerformed(null);
                }
            }
        });
        keyword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    addActionListener.actionPerformed(null);
                }
            }
        });
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
    }

    private void addButtonActionListener(JTextField keywordTextField) {
        if (StringUtil.isBlank(keywordTextField.getText())) {
            return;
        }
        this.addKeywordToKeywordListModel(keywordTextField.getText());
        keywordTextField.setText(null);
        keywordTextField.requestFocusInWindow();
    }

    private void addKeywordToKeywordListModel(String keyword) {
        String keywordToAdd = Objects.requireNonNull(keyword).trim();
        Keyword newKeyword = new Keyword(keywordToAdd);
        if (this.keywordListModel.isEmpty()) {
            this.keywordListModel.addElement(newKeyword);
        } else {
            int idx;
            Keyword element = this.keywordListModel.getElementAt(idx);
            for (idx = 0; idx < this.keywordListModel.size() && element.compareTo(newKeyword) < 0; ++idx) {
            }
            if (idx == this.keywordListModel.size()) {
                this.keywordListModel.addElement(newKeyword);
            } else if (element.compareTo(newKeyword) != 0) {
                this.keywordListModel.add(idx, newKeyword);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BasePanel bp = this.frame.getCurrentBasePanel();
        if (bp == null) {
            return;
        }
        if (bp.getSelectedEntries().isEmpty()) {
            bp.output(Localization.lang("Select at least one entry to manage keywords.", new String[0]));
            return;
        }
        this.createDialog();
        this.canceled = true;
        this.fillKeyWordList();
        this.diag.pack();
        this.diag.setLocationRelativeTo(this.frame);
        this.diag.setVisible(true);
        if (this.canceled) {
            return;
        }
        KeywordList keywordsToAdd = new KeywordList();
        KeywordList userSelectedKeywords = new KeywordList();
        Enumeration<Keyword> keywords = this.keywordListModel.elements();
        while (keywords.hasMoreElements()) {
            Keyword keyword = keywords.nextElement();
            userSelectedKeywords.add(keyword);
            if (this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.contains(keyword)) continue;
            keywordsToAdd.add(keyword);
        }
        KeywordList keywordsToRemove = new KeywordList();
        for (Keyword kword : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            if (userSelectedKeywords.contains(kword)) continue;
            keywordsToRemove.add(kword);
        }
        if (keywordsToAdd.isEmpty() && keywordsToRemove.isEmpty()) {
            return;
        }
        if (Globals.prefs.isKeywordSyncEnabled() && !keywordsToAdd.isEmpty()) {
            SpecialFieldsUtils.synchronizeSpecialFields(keywordsToAdd, keywordsToRemove);
        }
        NamedCompound ce = this.updateKeywords(bp.getSelectedEntries(), keywordsToAdd, keywordsToRemove);
        bp.getUndoManager().addEdit(ce);
        bp.markBaseChanged();
    }

    private NamedCompound updateKeywords(List<BibEntry> entries, KeywordList keywordsToAdd, KeywordList keywordsToRemove) {
        NamedCompound ce = new NamedCompound(Localization.lang("Update keywords", new String[0]));
        for (BibEntry entry : entries) {
            KeywordList keywords = entry.getKeywords(Globals.prefs.getKeywordDelimiter());
            keywords.removeAll(keywordsToRemove);
            keywords.addAll(keywordsToAdd);
            Optional<FieldChange> change = entry.putKeywords(keywords, Globals.prefs.getKeywordDelimiter());
            if (change.isPresent()) {
                ce.addEdit(new UndoableFieldChange(change.get()));
            }
            if (!Globals.prefs.isKeywordSyncEnabled()) continue;
            SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, Globals.prefs.getKeywordDelimiter());
        }
        ce.end();
        return ce;
    }

    private void fillKeyWordList() {
        BasePanel bp = this.frame.getCurrentBasePanel();
        List<BibEntry> entries = bp.getSelectedEntries();
        this.keywordListModel.clear();
        this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.clear();
        if (this.mergeKeywords.isSelected()) {
            for (BibEntry entry : entries) {
                KeywordList separatedKeywords = entry.getKeywords(Globals.prefs.getKeywordDelimiter());
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            }
        } else {
            assert (this.intersectKeywords.isSelected());
            BibEntry firstEntry = entries.get(0);
            KeywordList separatedKeywords = firstEntry.getKeywords(Globals.prefs.getKeywordDelimiter());
            this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            for (int i = 1; i < entries.size(); ++i) {
                BibEntry entry = entries.get(i);
                separatedKeywords = entry.getKeywords(Globals.prefs.getKeywordDelimiter());
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.retainAll(separatedKeywords);
            }
        }
        for (Keyword keyword : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            this.keywordListModel.addElement(keyword);
        }
    }
}

