/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.keyboard.EmacsKeyBindings;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.specialfields.SpecialField;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIGlobals {
    public static Color editorTextColor;
    public static Color validFieldBackgroundColor;
    public static Color activeBackgroundColor;
    public static Color invalidFieldBackgroundColor;
    public static Font currentFont;
    public static final Color NULL_FIELD_COLOR;
    public static final Color ACTIVE_EDITOR_COLOR;
    public static final int WIDTH_ICON_COL;
    public static final int WIDTH_ICON_COL_RANKING;
    public static final String UNTITLED_TITLE;
    public static final int MAX_BACK_HISTORY_SIZE = 10;
    public static final Color ENTRY_EDITOR_LABEL_COLOR;
    static final Color INACTIVE_TABBED_COLOR;
    private static final Logger LOGGER;
    private static final Map<String, JLabel> TABLE_ICONS;
    static final Color ACTIVE_TABBED_COLOR;

    private GUIGlobals() {
    }

    public static JLabel getTableIcon(String fieldType) {
        JLabel label = TABLE_ICONS.get(fieldType);
        if (label == null) {
            LOGGER.info("Error: no table icon defined for type '" + fieldType + "'.");
            return null;
        }
        return label;
    }

    public static void updateEntryEditorColors() {
        activeBackgroundColor = JabRefPreferences.getInstance().getColor("activeFieldEditorBackgroundColor");
        validFieldBackgroundColor = JabRefPreferences.getInstance().getColor("validFieldBackgroundColor");
        invalidFieldBackgroundColor = JabRefPreferences.getInstance().getColor("invalidFieldBackgroundColor");
        editorTextColor = JabRefPreferences.getInstance().getColor("fieldEditorTextColor");
    }

    public static void init() {
        JLabel label = new JLabel(IconTheme.JabRefIcon.PDF_FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " PDF");
        TABLE_ICONS.put("pdf", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " URL");
        TABLE_ICONS.put("url", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " CiteSeer URL");
        TABLE_ICONS.put("citeseerurl", label);
        label = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " ArXiv URL");
        TABLE_ICONS.put("eprint", label);
        label = new JLabel(IconTheme.JabRefIcon.DOI.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " DOI " + Localization.lang("web link", new String[0]));
        TABLE_ICONS.put("doi", label);
        label = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open", new String[0]) + " PS");
        TABLE_ICONS.put("ps", label);
        label = new JLabel(IconTheme.JabRefIcon.FOLDER.getSmallIcon());
        label.setToolTipText(Localization.lang("Open folder", new String[0]));
        TABLE_ICONS.put("folder", label);
        label = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
        label.setToolTipText(Localization.lang("Open file", new String[0]));
        TABLE_ICONS.put("file", label);
        for (ExternalFileType fileType : ExternalFileTypes.getInstance().getExternalFileTypeSelection()) {
            label = new JLabel(fileType.getIcon());
            label.setToolTipText(Localization.lang("Open %0 file", fileType.getName()));
            TABLE_ICONS.put(fileType.getName(), label);
        }
        SpecialFieldViewModel relevanceViewModel = new SpecialFieldViewModel(SpecialField.RELEVANCE);
        label = new JLabel(relevanceViewModel.getRepresentingIcon());
        label.setToolTipText(relevanceViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.RELEVANCE.getFieldName(), label);
        SpecialFieldViewModel qualityViewModel = new SpecialFieldViewModel(SpecialField.QUALITY);
        label = new JLabel(qualityViewModel.getRepresentingIcon());
        label.setToolTipText(qualityViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.QUALITY.getFieldName(), label);
        SpecialFieldViewModel rankViewModel = new SpecialFieldViewModel(SpecialField.RANKING);
        label = new JLabel(rankViewModel.getRepresentingIcon());
        label.setToolTipText(rankViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.RANKING.getFieldName(), label);
        SpecialFieldViewModel priorityViewModel = new SpecialFieldViewModel(SpecialField.PRIORITY);
        label = new JLabel(priorityViewModel.getRepresentingIcon());
        label.setToolTipText(priorityViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.PRIORITY.getFieldName(), label);
        SpecialFieldViewModel readViewModel = new SpecialFieldViewModel(SpecialField.READ_STATUS);
        label = new JLabel(readViewModel.getRepresentingIcon());
        label.setToolTipText(readViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.READ_STATUS.getFieldName(), label);
        SpecialFieldViewModel printedViewModel = new SpecialFieldViewModel(SpecialField.PRINTED);
        label = new JLabel(printedViewModel.getRepresentingIcon());
        label.setToolTipText(printedViewModel.getLocalization());
        TABLE_ICONS.put(SpecialField.PRINTED.getFieldName(), label);
        if (Globals.prefs.getBoolean("editorEMACSkeyBindings")) {
            EmacsKeyBindings.load();
        }
        GUIGlobals.updateEntryEditorColors();
        currentFont = new Font(Globals.prefs.get("fontFamily"), Globals.prefs.getInt("fontStyle"), Globals.prefs.getInt("fontSize"));
        if (!OS.WINDOWS && !OS.OS_X) {
            try {
                Toolkit xToolkit = Toolkit.getDefaultToolkit();
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, "org-jabref-JabRefMain");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFont(int size) {
        currentFont = new Font(currentFont.getFamily(), currentFont.getStyle(), size);
        Globals.prefs.putInt("fontSize", size);
    }

    static {
        NULL_FIELD_COLOR = new Color(75, 130, 95);
        ACTIVE_EDITOR_COLOR = new Color(230, 230, 255);
        WIDTH_ICON_COL = JabRefPreferences.getInstance().getInt("iconSizeSmall") + 12;
        WIDTH_ICON_COL_RANKING = 5 * JabRefPreferences.getInstance().getInt("iconSizeSmall");
        UNTITLED_TITLE = Localization.lang("untitled", new String[0]);
        ENTRY_EDITOR_LABEL_COLOR = new Color(100, 100, 150);
        INACTIVE_TABBED_COLOR = Color.black;
        LOGGER = LoggerFactory.getLogger(GUIGlobals.class);
        TABLE_ICONS = new HashMap<String, JLabel>();
        ACTIVE_TABBED_COLOR = ENTRY_EDITOR_LABEL_COLOR.darker();
    }
}

