/*
 * Decompiled with CFR 0.152.
 */
package org.jabref;

import com.google.common.base.StandardSystemProperty;
import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.telemetry.SessionState;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.Optional;
import java.util.UUID;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.GlobalFocusListener;
import org.jabref.gui.StateManager;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.util.DefaultFileUpdateMonitor;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.importer.ImportFormatReader;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.remote.server.RemoteListenerServerLifecycle;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.JabRefPreferences;

public class Globals {
    public static final BuildInfo BUILD_INFO = new BuildInfo();
    public static final RemoteListenerServerLifecycle REMOTE_LISTENER = new RemoteListenerServerLifecycle();
    public static final ImportFormatReader IMPORT_FORMAT_READER = new ImportFormatReader();
    public static final TaskExecutor TASK_EXECUTOR = new DefaultTaskExecutor();
    public static JabRefPreferences prefs;
    public static JournalAbbreviationLoader journalAbbreviationLoader;
    public static ProtectedTermsLoader protectedTermsLoader;
    public static StateManager stateManager;
    public static ExporterFactory exportFactory;
    private static KeyBindingRepository keyBindingRepository;
    private static GlobalFocusListener focusListener;
    private static DefaultFileUpdateMonitor fileUpdateMonitor;
    private static TelemetryClient telemetryClient;

    private Globals() {
    }

    public static synchronized KeyBindingRepository getKeyPrefs() {
        if (keyBindingRepository == null) {
            keyBindingRepository = prefs.getKeyBindingRepository();
        }
        return keyBindingRepository;
    }

    public static void startBackgroundTasks() {
        focusListener = new GlobalFocusListener();
        fileUpdateMonitor = new DefaultFileUpdateMonitor();
        JabRefExecutorService.INSTANCE.executeInterruptableTask(fileUpdateMonitor, "FileUpdateMonitor");
        if (prefs.shouldCollectTelemetry().booleanValue() && !GraphicsEnvironment.isHeadless()) {
            Globals.startTelemetryClient();
        }
    }

    private static void stopTelemetryClient() {
        if (prefs.shouldCollectTelemetry().booleanValue()) {
            Globals.getTelemetryClient().ifPresent(client -> client.trackSessionState(SessionState.End));
            Globals.getTelemetryClient().ifPresent(client -> client.flush());
        }
    }

    private static void startTelemetryClient() {
        TelemetryConfiguration telemetryConfiguration = TelemetryConfiguration.getActive();
        telemetryConfiguration.setInstrumentationKey(BUILD_INFO.getAzureInstrumentationKey());
        telemetryConfiguration.setTrackingIsDisabled(prefs.shouldCollectTelemetry() == false);
        telemetryClient = new TelemetryClient(telemetryConfiguration);
        telemetryClient.getContext().getProperties().put("JabRef version", BUILD_INFO.getVersion().toString());
        telemetryClient.getContext().getProperties().put("Java version", StandardSystemProperty.JAVA_VERSION.value());
        telemetryClient.getContext().getUser().setId(prefs.getOrCreateUserId());
        telemetryClient.getContext().getSession().setId(UUID.randomUUID().toString());
        telemetryClient.getContext().getDevice().setOperatingSystem(StandardSystemProperty.OS_NAME.value());
        telemetryClient.getContext().getDevice().setOperatingSystemVersion(StandardSystemProperty.OS_VERSION.value());
        telemetryClient.getContext().getDevice().setScreenResolution(Toolkit.getDefaultToolkit().getScreenSize().toString());
        telemetryClient.trackSessionState(SessionState.Start);
    }

    public static GlobalFocusListener getFocusListener() {
        return focusListener;
    }

    public static FileUpdateMonitor getFileUpdateMonitor() {
        return fileUpdateMonitor;
    }

    public static void shutdownThreadPools() {
        TASK_EXECUTOR.shutdown();
        JabRefExecutorService.INSTANCE.shutdownEverything();
    }

    public static void stopBackgroundTasks() {
        Globals.stopTelemetryClient();
    }

    public static Optional<TelemetryClient> getTelemetryClient() {
        return Optional.ofNullable(telemetryClient);
    }

    static {
        stateManager = new StateManager();
    }
}

