/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.util.Iterator;
import javafx.scene.Node;
import javafx.stage.PopupWindow;
import javafx.stage.Window;

public class Utils {
    public static Window getWindow(Object owner) throws IllegalArgumentException {
        if (owner == null) {
            Window window = null;
            Iterator windows = Window.impl_getWindows();
            while (windows.hasNext() && (!(window = (Window)windows.next()).isFocused() || window instanceof PopupWindow)) {
            }
            return window;
        }
        if (owner instanceof Window) {
            return (Window)owner;
        }
        if (owner instanceof Node) {
            return ((Node)owner).getScene().getWindow();
        }
        throw new IllegalArgumentException("Unknown owner: " + owner.getClass());
    }

    public static final String getExcelLetterFromNumber(int number) {
        String letter = "";
        while (number >= 0) {
            int remainder = number % 26;
            letter = (char)(remainder + 65) + letter;
            number = number / 26 - 1;
        }
        return letter;
    }

    public static double clamp(double min2, double value, double max) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double nearest(double less2, double value, double more) {
        double lessDiff = value - less2;
        double moreDiff = more - value;
        if (lessDiff < moreDiff) {
            return less2;
        }
        return more;
    }
}

