/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.ris;

import de.undercouch.citeproc.ris.RISLibrary;
import de.undercouch.citeproc.ris.RISReferenceBuilder;
import de.undercouch.citeproc.ris.RISType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class RISParser {
    public RISLibrary parse(Reader r) throws IOException {
        String line;
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        RISLibrary result = new RISLibrary();
        RISReferenceBuilder builder = null;
        ArrayList<String> editors = new ArrayList<String>();
        ArrayList<String> tertiaryAuthors = new ArrayList<String>();
        ArrayList<String> subsidiaryAuthors = new ArrayList<String>();
        ArrayList<String> authors = new ArrayList<String>();
        ArrayList<String> keywords = new ArrayList<String>();
        ArrayList<String> fileAttachments = new ArrayList<String>();
        ArrayList<String> notes = new ArrayList<String>();
        ArrayList<String> translatedAuthors = new ArrayList<String>();
        int lc = 0;
        while ((line = br.readLine()) != null) {
            ++lc;
            if ((line = line.trim()).equals("ER  -")) {
                this.handleReference(builder, editors, tertiaryAuthors, subsidiaryAuthors, authors, keywords, fileAttachments, notes, translatedAuthors, result);
                editors.clear();
                tertiaryAuthors.clear();
                subsidiaryAuthors.clear();
                authors.clear();
                keywords.clear();
                fileAttachments.clear();
                notes.clear();
                translatedAuthors.clear();
                builder = null;
                continue;
            }
            if (line.length() < 7) {
                throw new IOException("Line " + lc + " is too short");
            }
            if (line.charAt(4) != '-') {
                throw new IOException("Tag and value must be separated by '-' character in line " + lc);
            }
            String key = line.substring(0, 2).trim();
            String value = line.substring(6).trim();
            if (builder == null) {
                builder = new RISReferenceBuilder();
            }
            if (key.equalsIgnoreCase("TY")) {
                builder.type(this.parseType(value, lc));
                continue;
            }
            if (key.equalsIgnoreCase("A2")) {
                editors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("A3")) {
                tertiaryAuthors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("A4")) {
                subsidiaryAuthors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("AB")) {
                builder.abstrct(value);
                continue;
            }
            if (key.equalsIgnoreCase("AD")) {
                builder.authorAddress(value);
                continue;
            }
            if (key.equalsIgnoreCase("AN")) {
                builder.accessionNumber(value);
                continue;
            }
            if (key.equalsIgnoreCase("AU")) {
                authors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("BT")) {
                builder.bookOrConference(value);
                continue;
            }
            if (key.equalsIgnoreCase("C1")) {
                builder.custom1(value);
                continue;
            }
            if (key.equalsIgnoreCase("C2")) {
                builder.custom2(value);
                continue;
            }
            if (key.equalsIgnoreCase("C3")) {
                builder.custom3(value);
                continue;
            }
            if (key.equalsIgnoreCase("C4")) {
                builder.custom4(value);
                continue;
            }
            if (key.equalsIgnoreCase("C5")) {
                builder.custom5(value);
                continue;
            }
            if (key.equalsIgnoreCase("C6")) {
                builder.custom6(value);
                continue;
            }
            if (key.equalsIgnoreCase("C7")) {
                builder.custom7(value);
                continue;
            }
            if (key.equalsIgnoreCase("C8")) {
                builder.custom8(value);
                continue;
            }
            if (key.equalsIgnoreCase("CA")) {
                builder.caption(value);
                continue;
            }
            if (key.equalsIgnoreCase("CN")) {
                builder.callNumber(value);
                continue;
            }
            if (key.equalsIgnoreCase("CY")) {
                builder.place(value);
                continue;
            }
            if (key.equalsIgnoreCase("DA")) {
                builder.date(value);
                continue;
            }
            if (key.equalsIgnoreCase("DB")) {
                builder.nameOfDatabase(value);
                continue;
            }
            if (key.equalsIgnoreCase("DO")) {
                builder.DOI(value);
                continue;
            }
            if (key.equalsIgnoreCase("DP")) {
                builder.databaseProvider(value);
                continue;
            }
            if (key.equalsIgnoreCase("ED")) {
                editors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("EP")) {
                builder.endPage(value);
                continue;
            }
            if (key.equalsIgnoreCase("ET")) {
                builder.edition(value);
                continue;
            }
            if (key.equalsIgnoreCase("ID")) {
                builder.id(value);
                continue;
            }
            if (key.equalsIgnoreCase("IS")) {
                builder.issue(value);
                continue;
            }
            if (key.equalsIgnoreCase("JO")) {
                builder.journal(value);
                continue;
            }
            if (key.equalsIgnoreCase("J2")) {
                builder.journal(value);
                continue;
            }
            if (key.equalsIgnoreCase("KW")) {
                keywords.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("L1")) {
                fileAttachments.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("L4")) {
                builder.figure(value);
                continue;
            }
            if (key.equalsIgnoreCase("LA")) {
                builder.language(value);
                continue;
            }
            if (key.equalsIgnoreCase("LB")) {
                builder.label(value);
                continue;
            }
            if (key.equalsIgnoreCase("M1")) {
                builder.number(value);
                continue;
            }
            if (key.equalsIgnoreCase("M3")) {
                builder.typeOfWork(value);
                continue;
            }
            if (key.equalsIgnoreCase("N1")) {
                notes.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("N2")) {
                builder.abstrct(value);
                continue;
            }
            if (key.equalsIgnoreCase("NV")) {
                builder.numberOfVolumes(value);
                continue;
            }
            if (key.equalsIgnoreCase("OP")) {
                builder.originalPublication(value);
                continue;
            }
            if (key.equalsIgnoreCase("PB")) {
                builder.publisher(value);
                continue;
            }
            if (key.equalsIgnoreCase("PY")) {
                builder.year(value);
                continue;
            }
            if (key.equalsIgnoreCase("RI")) {
                builder.reviewedItem(value);
                continue;
            }
            if (key.equalsIgnoreCase("RN")) {
                builder.researchNotes(value);
                continue;
            }
            if (key.equalsIgnoreCase("RP")) {
                builder.reprintEdition(value);
                continue;
            }
            if (key.equalsIgnoreCase("SE")) {
                builder.section(value);
                continue;
            }
            if (key.equalsIgnoreCase("SN")) {
                builder.isbnOrIssn(value);
                continue;
            }
            if (key.equalsIgnoreCase("SP")) {
                builder.startPage(value);
                continue;
            }
            if (key.equalsIgnoreCase("ST")) {
                builder.shortTitle(value);
                continue;
            }
            if (key.equalsIgnoreCase("T1")) {
                builder.primaryTitle(value);
                continue;
            }
            if (key.equalsIgnoreCase("T2")) {
                builder.secondaryTitle(value);
                continue;
            }
            if (key.equalsIgnoreCase("T3")) {
                builder.tertiaryTitle(value);
                continue;
            }
            if (key.equalsIgnoreCase("TA")) {
                translatedAuthors.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("TI")) {
                builder.title(value);
                continue;
            }
            if (key.equalsIgnoreCase("TT")) {
                builder.translatedTitle(value);
                continue;
            }
            if (key.equalsIgnoreCase("U1")) {
                builder.typeOfWork(value);
                continue;
            }
            if (key.equalsIgnoreCase("UR")) {
                builder.URL(value);
                continue;
            }
            if (key.equalsIgnoreCase("VL")) {
                builder.volume(value);
                continue;
            }
            if (key.equalsIgnoreCase("Y2")) {
                builder.accessDate(value);
                continue;
            }
            throw new IOException("Illegal tag " + key + " in line " + lc);
        }
        this.handleReference(builder, editors, tertiaryAuthors, subsidiaryAuthors, authors, keywords, fileAttachments, notes, translatedAuthors, result);
        return result;
    }

    private void handleReference(RISReferenceBuilder builder, List<String> editors, List<String> tertiaryAuthors, List<String> subsidiaryAuthors, List<String> authors, List<String> keywords, List<String> fileAttachments, List<String> notes, List<String> translatedAuthors, RISLibrary result) {
        if (builder != null) {
            if (!editors.isEmpty()) {
                builder.editors(editors.toArray(new String[editors.size()]));
            }
            if (!tertiaryAuthors.isEmpty()) {
                builder.tertiaryAuthors(tertiaryAuthors.toArray(new String[tertiaryAuthors.size()]));
            }
            if (!subsidiaryAuthors.isEmpty()) {
                builder.subsidiaryAuthors(subsidiaryAuthors.toArray(new String[subsidiaryAuthors.size()]));
            }
            if (!authors.isEmpty()) {
                builder.authors(authors.toArray(new String[authors.size()]));
            }
            if (!keywords.isEmpty()) {
                builder.keywords(keywords.toArray(new String[keywords.size()]));
            }
            if (!fileAttachments.isEmpty()) {
                builder.fileAttachments(fileAttachments.toArray(new String[fileAttachments.size()]));
            }
            if (!notes.isEmpty()) {
                builder.notes(notes.toArray(new String[notes.size()]));
            }
            if (!translatedAuthors.isEmpty()) {
                builder.translatedAuthors(translatedAuthors.toArray(new String[translatedAuthors.size()]));
            }
            result.addReference(builder.build());
        }
    }

    private RISType parseType(String value, int lc) throws IOException {
        try {
            return RISType.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unknown type in line " + lc);
        }
    }
}

