/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FunctionCallCommand;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.protocol.v30.ProtocolListener;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;

public class FunctionCallCommandImpl
extends CommandImpl
implements FunctionCallCommand {
    private String functionName;
    private List<Type> parameterTypes;
    private List<Object> parameterValues;
    private Object result;
    private ProtocolListener listener = new BaseProtocolListener(){

        @Override
        public boolean isComplete() {
            return FunctionCallCommandImpl.this.result != null || FunctionCallCommandImpl.this.error != null || FunctionCallCommandImpl.this.exception != null;
        }

        @Override
        public synchronized void functionResult(Object value) {
            FunctionCallCommandImpl.this.result = value;
            this.notifyAll();
        }

        @Override
        public synchronized void error(Notice error) {
            FunctionCallCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            FunctionCallCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            FunctionCallCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    };

    public FunctionCallCommandImpl(String functionName, List<Type> parameterTypes, List<Object> parameterValues) {
        this.functionName = functionName;
        this.parameterTypes = parameterTypes;
        this.parameterValues = parameterValues;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        protocol.setListener(this.listener);
        int procId = protocol.getContext().getRegistry().lookupProcId(this.functionName);
        if (procId == 0) {
            throw new IOException("invalid function name");
        }
        ByteBuf msg = protocol.channel.alloc().buffer();
        protocol.writeFunctionCall(msg, procId, this.parameterTypes, this.parameterValues);
        protocol.writeSync(msg);
        protocol.send(msg);
        this.waitFor(this.listener);
    }
}

