/*
 * Decompiled with CFR 0.152.
 */
package com.airhacks.afterburner.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;

public class Configurator {
    public static final String CONFIGURATION_FILE = "configuration.properties";
    private final Properties systemProperties = System.getProperties();
    private Function<Object, Object> customConfigurator;
    private Consumer<String> LOG = l -> {};

    public Configurator set(Function<Object, Object> custom) {
        this.customConfigurator = custom;
        return this;
    }

    public Configurator setLogger(Consumer<String> log) {
        this.LOG = log;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties getProperties(Class<?> clazz) {
        Properties configuration = new Properties();
        try (InputStream stream = clazz.getResourceAsStream(CONFIGURATION_FILE);){
            if (stream == null) {
                Properties properties = null;
                return properties;
            }
            configuration.load(stream);
            return configuration;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return configuration;
    }

    public Object getProperty(Class<?> clazz, Object key) {
        Object value = this.systemProperties.get(key);
        if (value != null) {
            return value;
        }
        if (this.customConfigurator != null && (value = this.customConfigurator.apply(key)) != null) {
            return value;
        }
        Properties clazzProperties = this.getProperties(clazz);
        if (clazzProperties != null) {
            value = clazzProperties.get(key);
        }
        return value;
    }

    public void forgetAll() {
        this.customConfigurator = null;
    }
}

