/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import org.gradle.api.internal.tasks.compile.AbstractJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.ForkingJavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;

public class DefaultJavaCompileSpecFactory
extends AbstractJavaCompileSpecFactory<DefaultJavaCompileSpec> {
    public DefaultJavaCompileSpecFactory(CompileOptions compileOptions, JavaInstallationMetadata toolchain) {
        super(compileOptions, toolchain);
    }

    @Override
    protected DefaultJavaCompileSpec getCommandLineSpec(File executable) {
        return new DefaultCommandLineJavaSpec(executable);
    }

    @Override
    protected DefaultJavaCompileSpec getForkingSpec(File javaHome, int javaLanguageVersion) {
        return new DefaultForkingJavaCompileSpec(javaHome, javaLanguageVersion);
    }

    @Override
    protected DefaultJavaCompileSpec getInProcessSpec() {
        return new DefaultJavaCompileSpec();
    }

    private static class DefaultForkingJavaCompileSpec
    extends DefaultJavaCompileSpec
    implements ForkingJavaCompileSpec {
        private final File javaHome;
        private final int javaLanguageVersion;

        private DefaultForkingJavaCompileSpec(File javaHome, int javaLanguageVersion) {
            this.javaHome = javaHome;
            this.javaLanguageVersion = javaLanguageVersion;
        }

        @Override
        public File getJavaHome() {
            return this.javaHome;
        }

        @Override
        public int getJavaLanguageVersion() {
            return this.javaLanguageVersion;
        }
    }

    private static class DefaultCommandLineJavaSpec
    extends DefaultJavaCompileSpec
    implements CommandLineJavaCompileSpec {
        private final File executable;

        private DefaultCommandLineJavaSpec(File executable) {
            this.executable = executable;
        }

        @Override
        public File getExecutable() {
            return this.executable;
        }
    }
}

