/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceComponent;

class ScmImage
extends ScmDeviceComponent {
    Image image;
    int layout;
    boolean focusGained;

    ScmImage(Item item, Image image, int layout) {
        super(item, "image", false);
        this.image = image;
        this.layout = layout;
        if (item != null && (item.appearanceMode == 2 || item.appearanceMode == 1)) {
            this.setFocusable(true);
        }
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            int xp = 0;
            if ((this.layout & 2) != 0) {
                xp = this.getParent().getWidth() - this.image.getWidth();
            }
            if ((this.layout & 3) == 3) {
                xp /= 2;
            }
            g.drawImage(this.image._image, xp, 0, null);
            if (this.getFocusOwner() != null && this == this.getFocusOwner()) {
                g.setColor(Color.BLACK);
                g.drawRect(xp, 0, this.image._image.getWidth() - 1, this.image._image.getHeight() - 1);
            }
        }
    }

    public Dimension getMinimumSize() {
        if (this.image == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.image.getWidth(), this.image.getHeight());
    }

    public void focusGained() {
        this.getParent().focusGained();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

