/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.mini;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.yura.domination.engine.ColorUtil;
import net.yura.lobby.mini.MiniLobbyClient;
import net.yura.lobby.model.Game;
import net.yura.lobby.util.TimeoutUtil;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.TextArea;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.swingme.core.AnalogClock;

public class GameRenderer
extends DefaultListCellRenderer {
    AnalogClock clock = new AnalogClock();
    MiniLobbyClient lobby;
    ScaledIcon sicon;
    Game game;
    String line1;
    String line2;
    String part2;

    public GameRenderer(MiniLobbyClient l) {
        this.lobby = l;
        this.setName("ListRendererCollapsed");
        this.sicon = new ScaledIcon(XULLoader.adjustSizeToDensity((int)75), XULLoader.adjustSizeToDensity((int)47));
        int size = XULLoader.adjustSizeToDensity((int)25);
        this.clock.setSize(size, size);
        this.clock.setBackground(0xFFFFFF);
    }

    public Component getListCellRendererComponent(Component list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
        this.game = (Game)value;
        this.line1 = this.game.getName();
        this.sicon.setIcon(this.lobby.game.getIconForGame(this.game));
        this.setIcon(this.sicon);
        long time = (long)this.game.getTimeout() * 1000L;
        Calendar _now = Calendar.getInstance();
        _now.setTimeZone(TimeZone.getTimeZone("GMT"));
        _now.setTime(new Date(time));
        this.clock.setTime(_now);
        this.clock.setVisible(time != 0L);
        this.line2 = this.lobby.game.getGameDescription(this.game);
        if (time != 0L) {
            this.line2 = TimeoutUtil.formatPeriod((long)time) + " " + this.line2;
        }
        this.setVerticalTextPosition(this.line2 == null ? 2 : 16);
        this.part2 = this.game.getNumOfPlayers() + "/" + this.game.getMaxPlayers();
        return c;
    }

    public int getFixedCellHeight() {
        return this.padding * 2 + Math.max(this.sicon.getIconHeight(), this.getFont().getHeight() * 2 + this.gap + this.padding * 2);
    }

    public void paintComponent(Graphics2D g) {
        int color;
        String action;
        int state;
        super.paintComponent(g);
        int offsetx = this.padding + this.getIcon().getIconWidth() + this.gap;
        g.setFont(this.font);
        g.setColor(this.getForeground());
        g.drawString(this.line1, offsetx, this.padding);
        if (this.clock.isVisible()) {
            int offsety = this.getHeight() - this.clock.getHeight() - this.padding;
            this.clock.setForeground(this.getForeground());
            g.translate(offsetx, offsety);
            this.clock.paint(g);
            g.translate(-offsetx, -offsety);
            offsetx = offsetx + this.clock.getWidth() + this.padding;
        }
        if (((state = this.getCurrentState()) & 4) == 0 && (state & 8) == 0) {
            g.setColor(this.theme.getForeground(2));
        }
        int offsety = this.getHeight() - this.font.getHeight() - this.padding;
        int space = this.getWidth() - offsetx - this.font.getWidth("10/10");
        String drawString = this.font.getWidth(this.line2) > space ? this.line2.substring(0, TextArea.searchStringCharOffset((String)this.line2, (Font)this.font, (int)space)) + extension : this.line2;
        g.drawString(drawString, offsetx, offsety);
        g.drawString(this.part2, this.getWidth() - this.font.getWidth(this.part2) - this.padding, this.getHeight() - this.font.getHeight() - this.padding);
        switch (this.game.getState(this.lobby.whoAmI())) {
            case 1: {
                action = "Join";
                color = -16711936;
                break;
            }
            case 2: {
                action = "Leave";
                color = -65536;
                break;
            }
            case 4: {
                action = "Play";
                color = -16776961;
                break;
            }
            case 3: {
                action = "Watch";
                color = -1;
                break;
            }
            default: {
                action = null;
                color = 0;
            }
        }
        int actionx = this.getWidth();
        if (action != null) {
            int w = this.font.getWidth(action);
            int h = this.font.getHeight();
            g.setColor(color);
            actionx = this.getWidth() - w - this.padding * 3;
            g.fillRoundRect(actionx, this.padding, w + this.padding * 2, h + this.padding * 2, 5, 5);
            g.setColor(ColorUtil.getTextColorFor(color));
            g.drawString(action, this.getWidth() - w - this.padding * 2, this.padding * 2);
        }
        if (this.lobby.whoAmI().equals(this.game.getWhosTurn())) {
            int wh = this.font.getHeight();
            g.setColor(-65536);
            g.fillOval(actionx - wh - this.padding, (this.getHeight() - wh) / 2, wh, wh);
        }
    }

    public static class ScaledIcon
    extends Icon {
        Icon icon;

        public ScaledIcon(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public void setIcon(Icon i) {
            this.icon = i;
        }

        public void paintIcon(Component c, Graphics2D g, int x, int y) {
            g.translate(x, y);
            double sx = (double)this.width / (double)this.icon.getIconWidth();
            double sy = (double)this.height / (double)this.icon.getIconHeight();
            g.getGraphics().scale(sx, sy);
            this.icon.paintIcon(c, g, 0, 0);
            g.getGraphics().scale(1.0 / sx, 1.0 / sy);
            g.translate(-x, -y);
        }
    }
}

