/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.configuration.CompileOperationFactory;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.devel.internal.precompiled.FirstPassPrecompiledScriptRunner;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;
import org.gradle.plugin.management.PluginRequest;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.use.internal.PluginsAwareScript;

@CacheableTask
public abstract class GeneratePluginAdaptersTask
extends DefaultTask {
    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Inject
    protected abstract ClassLoaderScopeRegistry getClassLoaderScopeRegistry();

    @Inject
    protected abstract ScriptCompilationHandler getScriptCompilationHandler();

    @Inject
    protected abstract CompileOperationFactory getCompileOperationFactory();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    abstract DirectoryProperty getExtractedPluginRequestsClassesDirectory();

    @OutputDirectory
    abstract DirectoryProperty getPluginAdapterSourcesOutputDirectory();

    @Internal
    abstract ListProperty<PrecompiledGroovyScript> getScriptPlugins();

    @TaskAction
    void generatePluginAdapters() {
        this.getFileSystemOperations().delete(spec -> spec.delete(new Object[]{this.getPluginAdapterSourcesOutputDirectory()}));
        ((Directory)this.getPluginAdapterSourcesOutputDirectory().get()).getAsFile().mkdirs();
        for (PrecompiledGroovyScript scriptPlugin : (List)this.getScriptPlugins().get()) {
            String firstPassCode = this.generateFirstPassAdapterCode(scriptPlugin);
            this.generateScriptPluginAdapter(scriptPlugin, firstPassCode);
        }
    }

    private String generateFirstPassAdapterCode(PrecompiledGroovyScript scriptPlugin) {
        CompiledScript<PluginsAwareScript, ?> pluginsBlock = this.loadCompiledPluginsBlocks(scriptPlugin);
        if (!pluginsBlock.getRunDoesSomething()) {
            return "";
        }
        PluginRequests pluginRequests = this.extractPluginRequests(pluginsBlock, scriptPlugin);
        this.validatePluginRequests(scriptPlugin, pluginRequests);
        StringBuilder applyPlugins = new StringBuilder();
        applyPlugins.append("            Class<? extends BasicScript> pluginsBlockClass = Class.forName(\"").append(scriptPlugin.getFirstPassClassName()).append("\").asSubclass(BasicScript.class);\n");
        applyPlugins.append("            BasicScript pluginsBlockScript = pluginsBlockClass.getDeclaredConstructor().newInstance();\n");
        applyPlugins.append("            pluginsBlockScript.setScriptSource(scriptSource(pluginsBlockClass));\n");
        applyPlugins.append("            pluginsBlockScript.init(target, target.getServices());\n");
        applyPlugins.append("            pluginsBlockScript.run();\n");
        for (PluginRequest pluginRequest : pluginRequests) {
            applyPlugins.append("            target.getPluginManager().apply(\"").append(pluginRequest.getId().getId()).append("\");\n");
        }
        return applyPlugins.toString();
    }

    private void validatePluginRequests(PrecompiledGroovyScript scriptPlugin, PluginRequests pluginRequests) {
        HashSet<String> validationErrors = new HashSet<String>();
        for (PluginRequest pluginRequest : pluginRequests) {
            if (pluginRequest.getVersion() == null) continue;
            validationErrors.add(String.format("Invalid plugin request %s. Plugin requests from precompiled scripts must not include a version number. Please remove the version from the offending request and make sure the module containing the requested plugin '%s' is an implementation dependency", pluginRequest, pluginRequest.getId()));
        }
        if (!validationErrors.isEmpty()) {
            throw new LocationAwareException((Throwable)new IllegalArgumentException(String.join((CharSequence)"\n", validationErrors)), scriptPlugin.getBodySource().getResource().getLocation().getDisplayName(), ((PluginRequestInternal)pluginRequests.iterator().next()).getLineNumber());
        }
    }

    private PluginRequests extractPluginRequests(CompiledScript<PluginsAwareScript, ?> pluginsBlock, PrecompiledGroovyScript scriptPlugin) {
        try {
            PluginsAwareScript pluginsAwareScript = (PluginsAwareScript)pluginsBlock.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pluginsAwareScript.setScriptSource(scriptPlugin.getBodySource());
            pluginsAwareScript.init((Object)new FirstPassPrecompiledScriptRunner(), this.getServices());
            pluginsAwareScript.run();
            return pluginsAwareScript.getPluginRequests();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Could not execute plugins block", e);
        }
    }

    private CompiledScript<PluginsAwareScript, ?> loadCompiledPluginsBlocks(PrecompiledGroovyScript scriptPlugin) {
        ClassLoaderScope classLoaderScope = this.getClassLoaderScopeRegistry().getCoreAndPluginsScope();
        CompileOperation pluginsCompileOperation = this.getCompileOperationFactory().getPluginsBlockCompileOperation(scriptPlugin.getScriptTarget());
        File compiledPluginRequestsDir = ((Directory)this.getExtractedPluginRequestsClassesDirectory().get()).dir(scriptPlugin.getId()).getAsFile();
        return this.getScriptCompilationHandler().loadFromDir(scriptPlugin.getFirstPassSource(), scriptPlugin.getContentHash(), classLoaderScope, DefaultClassPath.of((File[])new File[]{compiledPluginRequestsDir}), compiledPluginRequestsDir, pluginsCompileOperation, PluginsAwareScript.class);
    }

    private void generateScriptPluginAdapter(PrecompiledGroovyScript scriptPlugin, String firstPassCode) {
        String targetClass = scriptPlugin.getTargetClassName();
        File outputFile = ((RegularFile)this.getPluginAdapterSourcesOutputDirectory().file(scriptPlugin.getPluginAdapterClassName() + ".java").get()).getAsFile();
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(Paths.get(outputFile.toURI()), new OpenOption[0]));){
            writer.println("//CHECKSTYLE:OFF");
            writer.println("import org.gradle.util.GradleVersion;");
            writer.println("import org.gradle.groovy.scripts.BasicScript;");
            writer.println("import org.gradle.groovy.scripts.ScriptSource;");
            writer.println("import org.gradle.groovy.scripts.TextResourceScriptSource;");
            writer.println("import org.gradle.internal.resource.StringTextResource;");
            writer.println("/**");
            writer.println(" * Precompiled " + scriptPlugin.getId() + " script plugin.");
            writer.println(" **/");
            writer.println("public class " + scriptPlugin.getPluginAdapterClassName() + " implements org.gradle.api.Plugin<" + targetClass + "> {");
            writer.println("    private static final String MIN_SUPPORTED_GRADLE_VERSION = \"5.0\";");
            writer.println("    public void apply(" + targetClass + " target) {");
            writer.println("        assertSupportedByCurrentGradleVersion();");
            writer.println("        try {");
            writer.println(firstPassCode);
            writer.println();
            writer.println("            Class<? extends BasicScript> precompiledScriptClass = Class.forName(\"" + scriptPlugin.getBodyClassName() + "\").asSubclass(BasicScript.class);");
            writer.println("            BasicScript script = precompiledScriptClass.getDeclaredConstructor().newInstance();");
            writer.println("            script.setScriptSource(scriptSource(precompiledScriptClass));");
            writer.println("            script.init(target, target.getServices());");
            writer.println("            script.run();");
            writer.println("        } catch (Exception e) {");
            writer.println("            throw new RuntimeException(e);");
            writer.println("        }");
            writer.println("  }");
            writer.println("  private static ScriptSource scriptSource(Class<?> scriptClass) {");
            writer.println("      return new TextResourceScriptSource(new StringTextResource(scriptClass.getSimpleName(), \"\"));");
            writer.println("  }");
            writer.println("  private static void assertSupportedByCurrentGradleVersion() {");
            writer.println("      if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version(MIN_SUPPORTED_GRADLE_VERSION)) < 0) {");
            writer.println("          throw new RuntimeException(\"Precompiled Groovy script plugins require Gradle \"+MIN_SUPPORTED_GRADLE_VERSION+\" or higher\");");
            writer.println("      }");
            writer.println("  }");
            writer.println("}");
            writer.println("//CHECKSTYLE:ON");
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

