/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.DslOriginDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final ResolveState resolveState;
    private final List<NodeState> targetNodes = Lists.newLinkedList();
    private final boolean isTransitive;
    private final boolean isConstraint;
    private final int hashCode;
    private SelectorState selector;
    private ModuleVersionResolveException targetNodeSelectionFailure;
    private ImmutableAttributes cachedAttributes;
    private ExcludeSpec transitiveExclusions;
    private ExcludeSpec cachedEdgeExclusions;
    private ExcludeSpec cachedExclusions;
    private NodeState resolvedVariant;
    private boolean unattached;
    private boolean used;

    EdgeState(NodeState from, DependencyState dependencyState, ExcludeSpec transitiveExclusions, ResolveState resolveState) {
        this.from = from;
        this.dependencyState = dependencyState;
        this.dependencyMetadata = dependencyState.getDependency();
        this.transitiveExclusions = transitiveExclusions;
        this.resolveState = resolveState;
        this.isTransitive = from.isTransitive() && this.dependencyMetadata.isTransitive();
        this.isConstraint = this.dependencyMetadata.isConstraint();
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hashCode = this.from.hashCode();
        hashCode = 31 * hashCode + this.dependencyState.hashCode();
        if (this.transitiveExclusions != null) {
            hashCode = 31 * hashCode + this.transitiveExclusions.hashCode();
        }
        return hashCode;
    }

    void computeSelector() {
        this.selector = this.resolveState.getSelector(this.dependencyState, this.from.versionProvidedByAncestors(this.dependencyState));
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    @Override
    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    @Nullable
    ComponentState getTargetComponent() {
        if (!this.selector.isResolved() || this.selector.getFailure() != null) {
            return null;
        }
        return this.getSelectedComponent();
    }

    @Override
    public SelectorState getSelector() {
        return this.selector;
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    void attachToTargetConfigurations() {
        ModuleResolveState module;
        ComponentState targetComponent = this.getTargetComponent();
        if (targetComponent == null || !this.isUsed()) {
            return;
        }
        if (this.isConstraint && (module = targetComponent.getModule()).isPending()) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
            this.from.makePending(this);
            module.registerConstraintProvider(this.from);
            return;
        }
        this.calculateTargetConfigurations(targetComponent);
        for (NodeState targetConfiguration : this.targetNodes) {
            targetConfiguration.addIncomingEdge(this);
        }
        if (!this.targetNodes.isEmpty()) {
            this.selector.getTargetModule().removeUnattachedDependency(this);
        }
    }

    void cleanUpOnSourceChange(NodeState source) {
        this.removeFromTargetConfigurations();
        this.maybeDecreaseHardEdgeCount(source);
        this.selector.getTargetModule().removeUnattachedDependency(this);
        this.selector.release(this.resolveState.getConflictTracker());
    }

    void removeFromTargetConfigurations() {
        if (!this.targetNodes.isEmpty()) {
            for (NodeState targetConfiguration : this.targetNodes) {
                targetConfiguration.removeIncomingEdge(this);
            }
            this.targetNodes.clear();
        }
        this.targetNodeSelectionFailure = null;
    }

    void failWith(Throwable err) {
        this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), err);
    }

    public void restart() {
        if (this.from.isSelected()) {
            this.restartInternal(false);
        }
    }

    public void restartConnected() {
        if (this.from.isSelected() && this.isUsed()) {
            this.restartInternal(true);
        }
    }

    private void restartInternal(boolean checkUnattached) {
        this.removeFromTargetConfigurations();
        if (checkUnattached && !this.isUnattached()) {
            this.selector.getTargetModule().addUnattachedDependency(this);
        }
        this.attachToTargetConfigurations();
    }

    @Override
    public ImmutableAttributes getAttributes() {
        assert (this.cachedAttributes != null);
        return this.cachedAttributes;
    }

    private ImmutableAttributes safeGetAttributes() throws AttributeMergingException {
        ModuleResolveState module = this.selector.getTargetModule();
        this.cachedAttributes = module.mergedConstraintsAttributes(this.dependencyState.getDependency().getSelector().getAttributes());
        return this.cachedAttributes;
    }

    private void calculateTargetConfigurations(ComponentState targetComponent) {
        GraphVariantSelectionResult targetVariants;
        ComponentGraphResolveState targetComponentState = targetComponent.getResolveStateOrNull();
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        if (targetComponentState == null) {
            targetComponent.getModule().getPlatformState().addOrphanEdge(this);
            return;
        }
        if (this.isConstraint && !this.isVirtualDependency()) {
            List<NodeState> nodes = targetComponent.getNodes();
            for (NodeState nodeState : nodes) {
                if (!nodeState.isSelected()) continue;
                this.targetNodes.add(nodeState);
            }
            if (this.targetNodes.isEmpty()) {
                List<EdgeState> unattachedDependencies = targetComponent.getModule().getUnattachedDependencies();
                if (!unattachedDependencies.isEmpty()) {
                    for (EdgeState otherEdge : unattachedDependencies) {
                        if (otherEdge == this || otherEdge.isConstraint()) continue;
                        otherEdge.attachToTargetConfigurations();
                        if (otherEdge.targetNodeSelectionFailure == null) break;
                        this.targetNodeSelectionFailure = otherEdge.targetNodeSelectionFailure;
                        return;
                    }
                }
                for (NodeState node : nodes) {
                    if (!node.isSelected()) continue;
                    this.targetNodes.add(node);
                }
            }
            return;
        }
        try {
            ImmutableAttributes attributes = this.resolveState.getRoot().getMetadata().getAttributes();
            attributes = this.resolveState.getAttributesFactory().concat(attributes, this.safeGetAttributes());
            targetVariants = this.dependencyMetadata.selectVariants(this.resolveState.getVariantSelector(), attributes, targetComponentState, this.resolveState.getAttributesSchema(), this.dependencyState.getDependency().getSelector().getRequestedCapabilities());
        }
        catch (AttributeMergingException mergeError) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), (Factory<String>)((Factory)() -> {
                Attribute attribute = mergeError.getAttribute();
                Object constraintValue = mergeError.getLeftValue();
                Object dependencyValue = mergeError.getRightValue();
                return "Inconsistency between attributes of a constraint and a dependency, on attribute '" + attribute + "' : dependency requires '" + dependencyValue + "' while constraint required '" + constraintValue + "'";
            }));
            return;
        }
        catch (Exception t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.dependencyState.getRequested(), (Throwable)t);
            return;
        }
        for (VariantGraphResolveState variantGraphResolveState : targetVariants.getVariants()) {
            NodeState targetNodeState = this.resolveState.getNode(targetComponent, variantGraphResolveState, targetVariants.isSelectedByVariantAwareResolution());
            this.targetNodes.add(targetNodeState);
        }
    }

    private boolean isVirtualDependency() {
        return this.selector.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata;
    }

    @Override
    public ExcludeSpec getExclusions() {
        if (this.cachedExclusions == null) {
            this.computeExclusions();
        }
        return this.cachedExclusions;
    }

    private void computeExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            this.cachedExclusions = this.transitiveExclusions;
        } else {
            this.computeExclusionsWhenExcludesPresent(excludes);
        }
    }

    private void computeExclusionsWhenExcludesPresent(List<ExcludeMetadata> excludes) {
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        ExcludeSpec edgeExclusions = moduleExclusions.excludeAny(excludes);
        this.cachedExclusions = moduleExclusions.excludeAny(edgeExclusions, this.transitiveExclusions);
    }

    ExcludeSpec getEdgeExclusions() {
        if (this.cachedEdgeExclusions == null) {
            List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
            ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
            if (excludes.isEmpty()) {
                return moduleExclusions.nothing();
            }
            this.cachedEdgeExclusions = moduleExclusions.excludeAny(excludes);
        }
        return this.cachedEdgeExclusions;
    }

    @Override
    public boolean contributesArtifacts() {
        return !this.isConstraint;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.resolveState.desugarSelector(this.dependencyState.getRequested());
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        ModuleVersionResolveException selectorFailure = this.selector.getFailure();
        if (selectorFailure != null) {
            return selectorFailure;
        }
        ComponentState selectedComponent = this.getSelectedComponent();
        if (selectedComponent == null) {
            ModuleSelectors<SelectorState> selectors = this.selector.getTargetModule().getSelectors();
            for (SelectorState state : selectors) {
                selectorFailure = state.getFailure();
                if (selectorFailure == null) continue;
                return selectorFailure;
            }
            throw new IllegalStateException("Expected to find a selector with a failure but none was found");
        }
        return selectedComponent.getMetadataResolveFailure();
    }

    @Override
    public Long getSelected() {
        return this.getSelectedComponent().getResultId();
    }

    @Override
    public boolean isTargetVirtualPlatform() {
        ComponentState selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.getModule().isVirtualPlatform();
    }

    boolean hasSelectedVariant() {
        return this.resolvedVariant != null || !this.findTargetNodes().isEmpty();
    }

    @Override
    @Nullable
    public Long getSelectedVariant() {
        NodeState node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getNodeId();
    }

    @Nullable
    public NodeState getSelectedNode() {
        if (this.resolvedVariant != null) {
            return this.resolvedVariant;
        }
        List<NodeState> targetNodes = this.findTargetNodes();
        assert (!targetNodes.isEmpty());
        for (NodeState targetNode : targetNodes) {
            if (!targetNode.isSelected()) continue;
            this.resolvedVariant = targetNode;
            return this.resolvedVariant;
        }
        return null;
    }

    private List<NodeState> findTargetNodes() {
        ComponentState targetComponent;
        List<NodeState> targetNodes = this.targetNodes;
        if (targetNodes.isEmpty() && (targetComponent = this.getTargetComponent()) != null) {
            targetNodes = targetComponent.getNodes();
        }
        return targetNodes;
    }

    @Override
    public ComponentSelectionReason getReason() {
        return this.selector.getSelectionReason();
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public Long getFromVariant() {
        return this.from.getNodeId();
    }

    @Nullable
    private ComponentState getSelectedComponent() {
        return this.selector.getTargetModule().getSelected();
    }

    @Override
    public Dependency getOriginalDependency() {
        if (this.dependencyMetadata instanceof DslOriginDependencyMetadata) {
            return ((DslOriginDependencyMetadata)this.dependencyMetadata).getSource();
        }
        return null;
    }

    void maybeDecreaseHardEdgeCount(NodeState removalSource) {
        if (!this.isConstraint) {
            this.selector.getTargetModule().decreaseHardEdgeCount(removalSource);
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.hashCode;
    }

    DependencyState getDependencyState() {
        return this.dependencyState;
    }

    public void updateTransitiveExcludes(ExcludeSpec newResolutionFilter) {
        if (this.isConstraint) {
            return;
        }
        this.transitiveExclusions = newResolutionFilter;
        this.cachedExclusions = null;
        for (NodeState targetNode : this.targetNodes) {
            targetNode.updateTransitiveExcludes();
        }
    }

    @Nullable
    ExcludeSpec getTransitiveExclusions() {
        return this.transitiveExclusions;
    }

    public void markUnattached() {
        this.unattached = true;
    }

    public void markAttached() {
        this.unattached = false;
    }

    public boolean isUnattached() {
        return this.unattached;
    }

    void markUsed() {
        this.used = true;
    }

    void markUnused() {
        this.used = false;
    }

    boolean isUsed() {
        return this.used;
    }

    public boolean isArtifactOnlyEdge() {
        return !this.isTransitive && !this.dependencyMetadata.getArtifacts().isEmpty();
    }
}

