/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptorRegistry;
import org.gradle.internal.classpath.intercept.CallSiteDecorator;
import org.gradle.internal.classpath.intercept.InterceptScope;

@NonNullApi
public interface CallInterceptorResolver {
    public static final CallInterceptorResolver INTERCEPTOR_RESOLVER = new CallInterceptorResolverImpl();

    @Nullable
    public CallInterceptor resolveCallInterceptor(InterceptScope var1);

    public boolean isAwareOfCallSiteName(String var1);

    @NonNullApi
    public static final class CallInterceptorResolverImpl
    implements CallInterceptorResolver {
        @Override
        @Nullable
        public CallInterceptor resolveCallInterceptor(InterceptScope scope) {
            CallSiteDecorator currentDecorator = CallInterceptorRegistry.getGroovyCallDecorator();
            if (currentDecorator instanceof CallInterceptorResolver) {
                return ((CallInterceptorResolver)((Object)currentDecorator)).resolveCallInterceptor(scope);
            }
            return null;
        }

        @Override
        public boolean isAwareOfCallSiteName(String name) {
            CallSiteDecorator currentDecorator = CallInterceptorRegistry.getGroovyCallDecorator();
            if (currentDecorator instanceof CallInterceptorResolver) {
                return ((CallInterceptorResolver)((Object)currentDecorator)).isAwareOfCallSiteName(name);
            }
            return false;
        }
    }
}

