/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Public.h"

Public::Public(){
	number=0;
	d6 = new Dice(D6);
}

Public::Public(int n){
	number=n;
	d6 = new Dice(D6);
}
 
Public::~Public(){delete d6;}

void Public::set_number(int n){
	number=n;
} 
 
int Public::get_number(){
	return number;
}

int Public::throwin_distance(){
	return d6->roll();
}

int Public::throwin_direction(){
	switch(d6->roll()){
		case 1:
		case 2:
			return LEFT;
		case 3:
		case 4:
			return SIDE;
		case 5:
		case 6:
			return RIGHT;
		default: 
			return SIDE;
	}
}

int Public::aggress_player(){
	return d6->roll(2);
}

Player* Public::select_player(Team *t){
	return t->get_random_player();
}

int Public::select_player_num(Team *t){
	return t->get_random_player_num();
}

void Public::save_state(FILE * fd,int depth){
	char format[10];
	memset(format,0,10);
	
	for(int i=0;i<depth;i++)
		format[i] = ' ';
	format[depth-1] = '\0';
	fprintf(fd,"%s<number>%i</number>\n",format,number);
}






