/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, wHint, hHint, flushCache);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data = control.getLayoutData();
        if (data != null) {
            ((GridData)data).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        Control control = grid[row][column];
        if (control != null) {
            int j;
            GridData data = (GridData)control.getLayoutData();
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (0 <= i && i < rowCount && 0 <= j && j < columnCount && control == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        this.layout(composite, true, rect.x, rect.y, rect.width, rect.height, flushCache);
    }

    Point layout(Composite composite, boolean move, int x, int y, int width, int height, boolean flushCache) {
        int i;
        int k;
        int k2;
        int i2;
        int k3;
        int last;
        int i3;
        int j;
        GridData data;
        int i4;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] children = composite.getChildren();
        int count = 0;
        for (i4 = 0; i4 < children.length; ++i4) {
            Control control = children[i4];
            data = (GridData)control.getLayoutData();
            if (data != null && data.exclude) continue;
            children[count++] = children[i4];
        }
        if (count == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        for (i4 = 0; i4 < count; ++i4) {
            Control child = children[i4];
            data = (GridData)child.getLayoutData();
            if (data == null) {
                data = new GridData();
                child.setLayoutData(data);
            }
            if (flushCache) {
                data.flushCache();
            }
            data.computeSize(child, data.widthHint, data.heightHint, flushCache);
            if (data.grabExcessHorizontalSpace && data.minimumWidth > 0 && data.cacheWidth < data.minimumWidth) {
                int trim = 0;
                if (child instanceof Scrollable) {
                    Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                    trim = rect.width;
                } else {
                    trim = child.getBorderWidth() * 2;
                }
                data.cacheHeight = -1;
                data.cacheWidth = -1;
                data.computeSize(child, Math.max(0, data.minimumWidth - trim), data.heightHint, false);
            }
            if (!data.grabExcessVerticalSpace || data.minimumHeight <= 0) continue;
            data.cacheHeight = Math.max(data.cacheHeight, data.minimumHeight);
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.numColumns;
        Control[][] grid = new Control[4][columnCount];
        for (int i5 = 0; i5 < count; ++i5) {
            Control child = children[i5];
            GridData data2 = (GridData)child.getLayoutData();
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data2.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Control[][] newGrid = new Control[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Control[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index;
                    for (index = column; index < endCount && grid[row][index] == null; ++index) {
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            for (j = 0; j < vSpan; ++j) {
                if (grid[row + j] == null) {
                    grid[row + j] = new Control[columnCount];
                }
                for (int k4 = 0; k4 < hSpan; ++k4) {
                    grid[row + j][column + k4] = child;
                }
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
        }
        int availableWidth = width - this.horizontalSpacing * (columnCount - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int expandCount = 0;
        int[] widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        for (j = 0; j < columnCount; ++j) {
            int hSpan;
            GridData data3;
            for (i3 = 0; i3 < rowCount; ++i3) {
                data3 = this.getData(grid, i3, j, rowCount, columnCount, true);
                if (data3 == null || (hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount))) != 1) continue;
                int w = data3.cacheWidth + data3.horizontalIndent;
                widths[j] = Math.max(widths[j], w);
                if (data3.grabExcessHorizontalSpace) {
                    if (!expandColumn[j]) {
                        ++expandCount;
                    }
                    expandColumn[j] = true;
                }
                if (data3.grabExcessHorizontalSpace && data3.minimumWidth == 0) continue;
                w = !data3.grabExcessHorizontalSpace || data3.minimumWidth == -1 ? data3.cacheWidth : data3.minimumWidth;
                minWidths[j] = Math.max(minWidths[j], w += data3.horizontalIndent);
            }
            for (i3 = 0; i3 < rowCount; ++i3) {
                int delta;
                int remainder;
                int w;
                data3 = this.getData(grid, i3, j, rowCount, columnCount, false);
                if (data3 == null || (hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount))) <= 1) continue;
                int spanWidth = 0;
                int spanMinWidth = 0;
                int spanExpandCount = 0;
                for (int k5 = 0; k5 < hSpan; ++k5) {
                    spanWidth += widths[j - k5];
                    spanMinWidth += minWidths[j - k5];
                    if (!expandColumn[j - k5]) continue;
                    ++spanExpandCount;
                }
                if (data3.grabExcessHorizontalSpace && spanExpandCount == 0) {
                    ++expandCount;
                    expandColumn[j] = true;
                }
                if ((w = data3.cacheWidth + data3.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                    if (this.makeColumnsEqualWidth) {
                        int equalWidth = (w + spanWidth) / hSpan;
                        remainder = (w + spanWidth) % hSpan;
                        last = -1;
                        for (k3 = 0; k3 < hSpan; ++k3) {
                            last = j - k3;
                            widths[last] = Math.max(equalWidth, widths[j - k3]);
                        }
                        if (last > -1) {
                            int n = last;
                            widths[n] = widths[n] + remainder;
                        }
                    } else if (spanExpandCount == 0) {
                        int n = j;
                        widths[n] = widths[n] + w;
                    } else {
                        delta = w / spanExpandCount;
                        remainder = w % spanExpandCount;
                        last = -1;
                        for (k3 = 0; k3 < hSpan; ++k3) {
                            if (!expandColumn[j - k3]) continue;
                            last = j - k3;
                            widths[last] = widths[last] + delta;
                        }
                        if (last > -1) {
                            int n = last;
                            widths[n] = widths[n] + remainder;
                        }
                    }
                }
                if (data3.grabExcessHorizontalSpace && data3.minimumWidth == 0) continue;
                int n = w = !data3.grabExcessHorizontalSpace || data3.minimumWidth == -1 ? data3.cacheWidth : data3.minimumWidth;
                if ((w += data3.horizontalIndent - spanMinWidth - (hSpan - 1) * this.horizontalSpacing) <= 0) continue;
                if (spanExpandCount == 0) {
                    int n2 = j;
                    minWidths[n2] = minWidths[n2] + w;
                    continue;
                }
                delta = w / spanExpandCount;
                remainder = w % spanExpandCount;
                last = -1;
                for (k3 = 0; k3 < hSpan; ++k3) {
                    if (!expandColumn[j - k3]) continue;
                    last = j - k3;
                    minWidths[last] = minWidths[last] + delta;
                }
                if (last <= -1) continue;
                int n3 = last;
                minWidths[n3] = minWidths[n3] + remainder;
            }
        }
        if (this.makeColumnsEqualWidth) {
            int i6;
            int minColumnWidth = 0;
            int columnWidth = 0;
            for (i6 = 0; i6 < columnCount; ++i6) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i6]);
                columnWidth = Math.max(columnWidth, widths[i6]);
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            for (i6 = 0; i6 < columnCount; ++i6) {
                expandColumn[i6] = expandCount > 0;
                widths[i6] = columnWidth;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            for (i3 = 0; i3 < columnCount; ++i3) {
                totalWidth += widths[i3];
            }
            int c = expandCount;
            int delta = (availableWidth - totalWidth) / c;
            int remainder = (availableWidth - totalWidth) % c;
            int last2 = -1;
            while (totalWidth != availableWidth) {
                int j2;
                for (j2 = 0; j2 < columnCount; ++j2) {
                    if (!expandColumn[j2]) continue;
                    if (widths[j2] + delta > minWidths[j2]) {
                        last2 = j2;
                        widths[last2] = widths[j2] + delta;
                        continue;
                    }
                    widths[j2] = minWidths[j2];
                    expandColumn[j2] = false;
                    --c;
                }
                if (last2 > -1) {
                    int n = last2;
                    widths[n] = widths[n] + remainder;
                }
                for (j2 = 0; j2 < columnCount; ++j2) {
                    for (i2 = 0; i2 < rowCount; ++i2) {
                        int w;
                        int hSpan;
                        GridData data4 = this.getData(grid, i2, j2, rowCount, columnCount, false);
                        if (data4 == null || (hSpan = Math.max(1, Math.min(data4.horizontalSpan, columnCount))) <= 1 || data4.grabExcessHorizontalSpace && data4.minimumWidth == 0) continue;
                        int spanWidth = 0;
                        int spanExpandCount = 0;
                        for (k3 = 0; k3 < hSpan; ++k3) {
                            spanWidth += widths[j2 - k3];
                            if (!expandColumn[j2 - k3]) continue;
                            ++spanExpandCount;
                        }
                        int n = w = !data4.grabExcessHorizontalSpace || data4.minimumWidth == -1 ? data4.cacheWidth : data4.minimumWidth;
                        if ((w += data4.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) <= 0) continue;
                        if (spanExpandCount == 0) {
                            int n4 = j2;
                            widths[n4] = widths[n4] + w;
                            continue;
                        }
                        int delta2 = w / spanExpandCount;
                        int remainder2 = w % spanExpandCount;
                        int last22 = -1;
                        for (k2 = 0; k2 < hSpan; ++k2) {
                            if (!expandColumn[j2 - k2]) continue;
                            last22 = j2 - k2;
                            widths[last22] = widths[last22] + delta2;
                        }
                        if (last22 <= -1) continue;
                        int n5 = last22;
                        widths[n5] = widths[n5] + remainder2;
                    }
                }
                if (c != 0) {
                    totalWidth = 0;
                    for (int i7 = 0; i7 < columnCount; ++i7) {
                        totalWidth += widths[i7];
                    }
                    delta = (availableWidth - totalWidth) / c;
                    remainder = (availableWidth - totalWidth) % c;
                    last2 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            for (int j3 = 0; j3 < columnCount; ++j3) {
                for (int i8 = 0; i8 < rowCount; ++i8) {
                    GridData data5 = this.getData(grid, i8, j3, rowCount, columnCount, false);
                    if (data5 == null || data5.heightHint != -1) continue;
                    Control child = grid[i8][j3];
                    int hSpan = Math.max(1, Math.min(data5.horizontalSpan, columnCount));
                    int currentWidth = 0;
                    for (int k6 = 0; k6 < hSpan; ++k6) {
                        currentWidth += widths[j3 - k6];
                    }
                    if (((currentWidth += (hSpan - 1) * this.horizontalSpacing - data5.horizontalIndent) == data5.cacheWidth || data5.horizontalAlignment != 4) && data5.cacheWidth <= currentWidth) continue;
                    int trim = 0;
                    if (child instanceof Scrollable) {
                        Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                        trim = rect.width;
                    } else {
                        trim = child.getBorderWidth() * 2;
                    }
                    data5.cacheHeight = -1;
                    data5.cacheWidth = -1;
                    data5.computeSize(child, Math.max(0, currentWidth - trim), data5.heightHint, false);
                    if (data5.grabExcessVerticalSpace && data5.minimumHeight > 0) {
                        data5.cacheHeight = Math.max(data5.cacheHeight, data5.minimumHeight);
                    }
                    if (flush == null) {
                        flush = new GridData[count];
                    }
                    flush[flushLength++] = data5;
                }
            }
        }
        int availableHeight = height - this.verticalSpacing * (rowCount - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        expandCount = 0;
        int[] heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        for (i2 = 0; i2 < rowCount; ++i2) {
            int vSpan;
            GridData data6;
            int j4;
            for (j4 = 0; j4 < columnCount; ++j4) {
                data6 = this.getData(grid, i2, j4, rowCount, columnCount, true);
                if (data6 == null || (vSpan = Math.max(1, Math.min(data6.verticalSpan, rowCount))) != 1) continue;
                int h = data6.cacheHeight + data6.verticalIndent;
                heights[i2] = Math.max(heights[i2], h);
                if (data6.grabExcessVerticalSpace) {
                    if (!expandRow[i2]) {
                        ++expandCount;
                    }
                    expandRow[i2] = true;
                }
                if (data6.grabExcessVerticalSpace && data6.minimumHeight == 0) continue;
                h = !data6.grabExcessVerticalSpace || data6.minimumHeight == -1 ? data6.cacheHeight : data6.minimumHeight;
                minHeights[i2] = Math.max(minHeights[i2], h += data6.verticalIndent);
            }
            for (j4 = 0; j4 < columnCount; ++j4) {
                int last3;
                int remainder;
                int delta;
                int h;
                data6 = this.getData(grid, i2, j4, rowCount, columnCount, false);
                if (data6 == null || (vSpan = Math.max(1, Math.min(data6.verticalSpan, rowCount))) <= 1) continue;
                int spanHeight = 0;
                int spanMinHeight = 0;
                int spanExpandCount = 0;
                for (int k7 = 0; k7 < vSpan; ++k7) {
                    spanHeight += heights[i2 - k7];
                    spanMinHeight += minHeights[i2 - k7];
                    if (!expandRow[i2 - k7]) continue;
                    ++spanExpandCount;
                }
                if (data6.grabExcessVerticalSpace && spanExpandCount == 0) {
                    ++expandCount;
                    expandRow[i2] = true;
                }
                if ((h = data6.cacheHeight + data6.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                    if (spanExpandCount == 0) {
                        int n = i2;
                        heights[n] = heights[n] + h;
                    } else {
                        delta = h / spanExpandCount;
                        remainder = h % spanExpandCount;
                        last3 = -1;
                        for (k = 0; k < vSpan; ++k) {
                            if (!expandRow[i2 - k]) continue;
                            last3 = i2 - k;
                            heights[last3] = heights[last3] + delta;
                        }
                        if (last3 > -1) {
                            int n = last3;
                            heights[n] = heights[n] + remainder;
                        }
                    }
                }
                if (data6.grabExcessVerticalSpace && data6.minimumHeight == 0) continue;
                int n = h = !data6.grabExcessVerticalSpace || data6.minimumHeight == -1 ? data6.cacheHeight : data6.minimumHeight;
                if ((h += data6.verticalIndent - spanMinHeight - (vSpan - 1) * this.verticalSpacing) <= 0) continue;
                if (spanExpandCount == 0) {
                    int n6 = i2;
                    minHeights[n6] = minHeights[n6] + h;
                    continue;
                }
                delta = h / spanExpandCount;
                remainder = h % spanExpandCount;
                last3 = -1;
                for (k = 0; k < vSpan; ++k) {
                    if (!expandRow[i2 - k]) continue;
                    last3 = i2 - k;
                    minHeights[last3] = minHeights[last3] + delta;
                }
                if (last3 <= -1) continue;
                int n7 = last3;
                minHeights[n7] = minHeights[n7] + remainder;
            }
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            for (int i9 = 0; i9 < rowCount; ++i9) {
                totalHeight += heights[i9];
            }
            int c = expandCount;
            int delta = (availableHeight - totalHeight) / c;
            int remainder = (availableHeight - totalHeight) % c;
            last = -1;
            while (totalHeight != availableHeight) {
                int i10;
                for (i10 = 0; i10 < rowCount; ++i10) {
                    if (!expandRow[i10]) continue;
                    if (heights[i10] + delta > minHeights[i10]) {
                        last = i10;
                        heights[last] = heights[i10] + delta;
                        continue;
                    }
                    heights[i10] = minHeights[i10];
                    expandRow[i10] = false;
                    --c;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                for (i10 = 0; i10 < rowCount; ++i10) {
                    for (int j5 = 0; j5 < columnCount; ++j5) {
                        int h;
                        int vSpan;
                        GridData data7 = this.getData(grid, i10, j5, rowCount, columnCount, false);
                        if (data7 == null || (vSpan = Math.max(1, Math.min(data7.verticalSpan, rowCount))) <= 1 || data7.grabExcessVerticalSpace && data7.minimumHeight == 0) continue;
                        int spanHeight = 0;
                        int spanExpandCount = 0;
                        for (k = 0; k < vSpan; ++k) {
                            spanHeight += heights[i10 - k];
                            if (!expandRow[i10 - k]) continue;
                            ++spanExpandCount;
                        }
                        int n = h = !data7.grabExcessVerticalSpace || data7.minimumHeight == -1 ? data7.cacheHeight : data7.minimumHeight;
                        if ((h += data7.verticalIndent - spanHeight - (vSpan - 1) * this.verticalSpacing) <= 0) continue;
                        if (spanExpandCount == 0) {
                            int n8 = i10;
                            heights[n8] = heights[n8] + h;
                            continue;
                        }
                        int delta2 = h / spanExpandCount;
                        int remainder2 = h % spanExpandCount;
                        int last2 = -1;
                        for (int k8 = 0; k8 < vSpan; ++k8) {
                            if (!expandRow[i10 - k8]) continue;
                            last2 = i10 - k8;
                            heights[last2] = heights[last2] + delta2;
                        }
                        if (last2 <= -1) continue;
                        int n9 = last2;
                        heights[n9] = heights[n9] + remainder2;
                    }
                }
                if (c == 0) break;
                totalHeight = 0;
                for (i10 = 0; i10 < rowCount; ++i10) {
                    totalHeight += heights[i10];
                }
                delta = (availableHeight - totalHeight) / c;
                remainder = (availableHeight - totalHeight) % c;
                last = -1;
            }
        }
        if (move) {
            int gridY = y + this.marginTop + this.marginHeight;
            for (int i11 = 0; i11 < rowCount; ++i11) {
                int gridX = x + this.marginLeft + this.marginWidth;
                for (int j6 = 0; j6 < columnCount; ++j6) {
                    GridData data8 = this.getData(grid, i11, j6, rowCount, columnCount, true);
                    if (data8 != null) {
                        int hSpan = Math.max(1, Math.min(data8.horizontalSpan, columnCount));
                        int vSpan = Math.max(1, data8.verticalSpan);
                        int cellWidth = 0;
                        int cellHeight = 0;
                        for (k2 = 0; k2 < hSpan; ++k2) {
                            cellWidth += widths[j6 + k2];
                        }
                        for (k2 = 0; k2 < vSpan; ++k2) {
                            cellHeight += heights[i11 + k2];
                        }
                        int childX = gridX + data8.horizontalIndent;
                        int childWidth = Math.min(data8.cacheWidth, cellWidth += this.horizontalSpacing * (hSpan - 1));
                        switch (data8.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childX += Math.max(0, (cellWidth - data8.horizontalIndent - childWidth) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                childX += Math.max(0, cellWidth - data8.horizontalIndent - childWidth);
                                break;
                            }
                            case 4: {
                                childWidth = cellWidth - data8.horizontalIndent;
                            }
                        }
                        int childY = gridY + data8.verticalIndent;
                        int childHeight = Math.min(data8.cacheHeight, cellHeight += this.verticalSpacing * (vSpan - 1));
                        switch (data8.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childY += Math.max(0, (cellHeight - data8.verticalIndent - childHeight) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                childY += Math.max(0, cellHeight - data8.verticalIndent - childHeight);
                                break;
                            }
                            case 4: {
                                childHeight = cellHeight - data8.verticalIndent;
                            }
                        }
                        Control child = grid[i11][j6];
                        if (child != null) {
                            child.setBounds(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j6] + this.horizontalSpacing;
                }
                gridY += heights[i11] + this.verticalSpacing;
            }
        }
        for (i2 = 0; i2 < flushLength; ++i2) {
            flush[i2].cacheHeight = -1;
            flush[i2].cacheWidth = -1;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        for (i = 0; i < columnCount; ++i) {
            totalDefaultWidth += widths[i];
        }
        for (i = 0; i < rowCount; ++i) {
            totalDefaultHeight += heights[i];
        }
        return new Point(totalDefaultWidth += this.horizontalSpacing * (columnCount - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, totalDefaultHeight += this.verticalSpacing * (rowCount - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        Object string = this.getName() + " {";
        if (this.numColumns != 1) {
            string = (String)string + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string = (String)string + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string = (String)string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = (String)string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = (String)string + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = (String)string + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = (String)string + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = (String)string + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string = (String)string + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string = (String)string + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string = ((String)string).trim();
        string = (String)string + "}";
        return string;
    }
}

