/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public abstract class AbstractResourceBasedComponentDiscoverer
implements ComponentDiscoverer {
    protected abstract String getComponentDescriptorLocation();

    protected abstract ComponentSetDescriptor createComponentDescriptors(Reader var1, String var2, ClassRealm var3) throws PlexusConfigurationException;

    @Override
    public List<ComponentSetDescriptor> findComponents(Context context, ClassRealm realm2) throws PlexusConfigurationException {
        Enumeration<URL> resources;
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        try {
            resources = realm2.getResources(this.getComponentDescriptorLocation());
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Unable to retrieve resources for: " + this.getComponentDescriptorLocation() + " in class realm: " + realm2.getId());
        }
        for (URL url : Collections.list(resources)) {
            XmlStreamReader reader = null;
            try {
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.connect();
                reader = ReaderFactory.newXmlReader(conn.getInputStream());
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, new ContextMapAdapter(context));
                ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(interpolationFilterReader, url.toString(), realm2);
                componentSetDescriptors.add(componentSetDescriptor);
            }
            catch (IOException ex) {
                try {
                    throw new PlexusConfigurationException("Error reading configuration " + url, ex);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        return componentSetDescriptors;
    }
}

