/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TailStream
extends FilterInputStream {
    private static final int SKIP_SIZE = 4096;
    private final byte[] tailBuffer;
    private final int tailSize;
    private byte[] markBuffer;
    private long bytesRead;
    private long markBytesRead;
    private int currentIndex;
    private int markIndex;

    public TailStream(InputStream in, int size2) {
        super(in);
        this.tailSize = size2;
        this.tailBuffer = new byte[size2];
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            this.appendByte((byte)c);
        }
        return c;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int read2 = super.read(buf);
        if (read2 > 0) {
            this.appendBuf(buf, 0, read2);
        }
        return read2;
    }

    @Override
    public int read(byte[] buf, int ofs, int length) throws IOException {
        int read2 = super.read(buf, ofs, length);
        if (read2 > 0) {
            this.appendBuf(buf, ofs, read2);
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        int bufSize = (int)Math.min(n, 4096L);
        byte[] buf = new byte[bufSize];
        long bytesSkipped = 0L;
        int bytesRead = 0;
        while (bytesSkipped < n && bytesRead != -1) {
            int len = (int)Math.min((long)bufSize, n - bytesSkipped);
            bytesRead = this.read(buf, 0, len);
            if (bytesRead == -1) continue;
            bytesSkipped += (long)bytesRead;
        }
        return bytesRead < 0 && bytesSkipped == 0L ? -1L : bytesSkipped;
    }

    @Override
    public void mark(int limit) {
        this.markBuffer = new byte[this.tailSize];
        System.arraycopy(this.tailBuffer, 0, this.markBuffer, 0, this.tailSize);
        this.markIndex = this.currentIndex;
        this.markBytesRead = this.bytesRead;
    }

    @Override
    public void reset() {
        if (this.markBuffer != null) {
            System.arraycopy(this.markBuffer, 0, this.tailBuffer, 0, this.tailSize);
            this.currentIndex = this.markIndex;
            this.bytesRead = this.markBytesRead;
        }
    }

    public byte[] getTail() {
        int size2 = (int)Math.min((long)this.tailSize, this.bytesRead);
        byte[] result2 = new byte[size2];
        System.arraycopy(this.tailBuffer, this.currentIndex, result2, 0, size2 - this.currentIndex);
        System.arraycopy(this.tailBuffer, 0, result2, size2 - this.currentIndex, this.currentIndex);
        return result2;
    }

    private void appendByte(byte b) {
        this.tailBuffer[this.currentIndex++] = b;
        if (this.currentIndex >= this.tailSize) {
            this.currentIndex = 0;
        }
        ++this.bytesRead;
    }

    private void appendBuf(byte[] buf, int ofs, int length) {
        if (length >= this.tailSize) {
            this.replaceTailBuffer(buf, ofs, length);
        } else {
            this.copyToTailBuffer(buf, ofs, length);
        }
        this.bytesRead += (long)length;
    }

    private void replaceTailBuffer(byte[] buf, int ofs, int length) {
        System.arraycopy(buf, ofs + length - this.tailSize, this.tailBuffer, 0, this.tailSize);
        this.currentIndex = 0;
    }

    private void copyToTailBuffer(byte[] buf, int ofs, int length) {
        int remaining = this.tailSize - this.currentIndex;
        int size1 = Math.min(remaining, length);
        System.arraycopy(buf, ofs, this.tailBuffer, this.currentIndex, size1);
        System.arraycopy(buf, ofs + size1, this.tailBuffer, 0, length - size1);
        this.currentIndex = (this.currentIndex + length) % this.tailSize;
    }
}

